/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JWindow;
import net.sf.amemailchecker.gui.notification.INotificationWindow;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.window.theme.DefaultNotificationWindowTheme;
import net.sf.amemailchecker.gui.notification.window.theme.NotificationWindowTheme;

public abstract class BaseNotificationWindow
extends JWindow
implements INotificationWindow {
    protected static NotificationWindowTheme theme = new DefaultNotificationWindowTheme();
    protected JPanel contentPanel = new JPanel();

    protected BaseNotificationWindow() {
    }

    protected BaseNotificationWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    protected void init() {
        this.construct();
        this.setContentPane(this.contentPanel);
        this.setSize();
        this.locate();
        this.setAlwaysOnTop(true);
    }

    protected abstract void construct();

    protected abstract void locate();

    protected void updateLook(NotificationType notificationType) {
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(theme.getBorderColor(notificationType)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.contentPanel.setBackground(theme.getBackgroundColor(notificationType));
    }

    protected void setSize() {
        Dimension dimension = this.getContentPane().getLayout().preferredLayoutSize(this.contentPanel);
        super.setSize(dimension);
    }

    @Override
    public void showNotification() {
        this.setVisible(true);
    }

    @Override
    public void hideNotification() {
        this.setVisible(false);
    }

    @Override
    public void showNotification(NotificationType notificationType) {
        this.updateLook(notificationType);
        this.showNotification();
    }
}

