/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.desktop;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.window.BaseNotificationWindow;
import net.sf.amemailchecker.gui.notification.window.desktop.DesktopNotificationWindowMouseListener;
import net.sf.amemailchecker.gui.notification.window.desktop.IDesktopNotificationWindow;

public abstract class BaseDesktopNotificationWindow
extends BaseNotificationWindow
implements IDesktopNotificationWindow {
    private DesktopNotificationWindowMouseListener mouseListener;

    @Override
    protected void construct() {
        this.contentPanel.setAlignmentX(0.5f);
        this.updateLook(NotificationType.INFO);
        this.mouseListener = new DesktopNotificationWindowMouseListener(this);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    @Override
    protected void locate() {
        Dimension dimension = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
        this.setLocation(dimension.width - this.getWidth(), dimension.height - this.getHeight());
    }

    @Override
    public void showNotification(int n) {
        this.showNotification();
        long l = System.currentTimeMillis() + (long)(n * 1000);
        while (l >= System.currentTimeMillis()) {
            if (l != System.currentTimeMillis()) continue;
            this.hideNotification();
        }
    }

    @Override
    public void showNotification(int n, NotificationType notificationType) {
        this.updateLook(notificationType);
        this.showNotification(n);
    }

    @Override
    public void hideNotification() {
        this.removeMouseMotionListener(this.mouseListener);
        super.hideNotification();
    }
}

