/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.desktop.slidein;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.AnimatingType;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.BaseSlideNotificationWindow;

class AnimatingPanel
extends JPanel {
    Dimension animatingSize = new Dimension(0, 1);
    JComponent source;
    BufferedImage offScreenImage;
    BaseSlideNotificationWindow notificationWindow;

    AnimatingPanel(BaseSlideNotificationWindow baseSlideNotificationWindow) {
        this.notificationWindow = baseSlideNotificationWindow;
        this.setOpaque(false);
    }

    public void setSource(JComponent jComponent) {
        this.source = jComponent;
        if (this.notificationWindow.isVerticalSlide()) {
            this.animatingSize.width = jComponent.getWidth();
        }
        if (this.notificationWindow.isOutAnimatingDirection() || this.notificationWindow.isHorizontalSlide()) {
            this.animatingSize.height = jComponent.getHeight();
        }
        this.makeOffScreenImage(jComponent);
    }

    public void setAnimatingHeight(int n) {
        this.animatingSize.height = n;
        this.setSize(this.animatingSize);
    }

    public void setAnimatingWidth(int n) {
        this.animatingSize.width = n;
        this.setSize(this.animatingSize);
    }

    private void makeOffScreenImage(JComponent jComponent) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        this.offScreenImage = graphicsConfiguration.createCompatibleImage(jComponent.getWidth(), jComponent.getHeight());
        Graphics2D graphics2D = (Graphics2D)this.offScreenImage.getGraphics();
        graphics2D.setColor(jComponent.getBackground());
        graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        jComponent.paint(graphics2D);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.animatingSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.animatingSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.animatingSize;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        BufferedImage bufferedImage = this.offScreenImage.getSubimage(this.notificationWindow.getAnimatingType().equals((Object)AnimatingType.SLIDE_RIGHT) ? this.source.getWidth() - this.animatingSize.width : 0, this.notificationWindow.getAnimatingType().equals((Object)AnimatingType.SLIDE_TOP) ? this.source.getHeight() - this.animatingSize.height : 0, this.notificationWindow.isVerticalSlide() ? this.source.getWidth() : this.animatingSize.width, this.notificationWindow.isVerticalSlide() ? this.animatingSize.height : this.source.getHeight());
        graphics.drawImage(bufferedImage, 0, 0, this);
    }
}

