/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.desktop.slidein;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JWindow;
import javax.swing.Timer;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.window.desktop.BaseDesktopNotificationWindow;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.AnimatingPanel;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.AnimatingType;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.BaseSlideActionListener;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.ISlideNotificationWindow;

public abstract class BaseSlideNotificationWindow
extends BaseDesktopNotificationWindow
implements ISlideNotificationWindow {
    private int displayDelay;
    protected static final int ANIMATION_DELAY = 10;
    protected static final int ANIMATION_TIME = 2000;
    private static final int DIRECTION_IN = 1;
    private static final int DIRECTION_OUT = -1;
    protected boolean interrupted = false;
    private AnimatingPanel animatingPanel;
    private Dimension tempWindowSize;
    private Timer animationTimer;
    private int showX;
    private int startY;
    private long animationStart;
    private AnimatingType animatingType = AnimatingType.SLIDE_BOTTOM;
    private int animatingDirection = 1;

    @Override
    protected void init() {
        super.init();
        this.createSlide();
    }

    @Override
    protected void updateLook(NotificationType notificationType) {
        super.updateLook(notificationType);
        this.createSlide();
    }

    private void createSlide() {
        JWindow jWindow = new JWindow();
        jWindow.getContentPane().add(this.contentPanel);
        jWindow.pack();
        this.tempWindowSize = jWindow.getSize();
        jWindow.getContentPane().removeAll();
        this.animatingPanel = new AnimatingPanel(this);
        this.updateSlide();
        this.setContentPane(this.animatingPanel);
    }

    private void updateSlide() {
        this.animatingPanel.setSource(this.contentPanel);
    }

    public int getDefaultY() {
        if (this.animatingType != null) {
            switch (this.animatingType) {
                case SLIDE_TOP: {
                    return 0;
                }
                case SLIDE_BOTTOM: {
                    return this.getY() + this.getHeight();
                }
            }
        }
        return this.getY();
    }

    public int getDefaultX() {
        if (this.animatingType != null) {
            switch (this.animatingType) {
                case SLIDE_RIGHT: {
                    return 0;
                }
                case SLIDE_LEFT: {
                    return this.getX() + this.getWidth();
                }
            }
        }
        return this.getX();
    }

    @Override
    protected void locate() {
        super.locate();
        this.setLocation(this.getDefaultX(), this.getDefaultY());
    }

    private void slideIn() {
        this.showX = this.getX();
        this.startY = this.getY();
        this.animationTimer = new Timer(10, new SlideInActionListener(2000L, System.currentTimeMillis()));
        this.animationTimer.start();
    }

    private void slideOut() {
        this.animatingDirection = -1;
        this.createSlide();
        this.showX = this.getX();
        this.startY = this.getY();
        this.animationTimer = new Timer(10, new SlideOutActionListener(2000L, System.currentTimeMillis()));
        this.animationTimer.start();
    }

    public void slideHold() {
        this.animationTimer = new Timer(this.displayDelay, new SlideHoldActionListener());
        this.animationStart = System.currentTimeMillis() + (long)this.displayDelay;
        this.animationTimer.start();
    }

    @Override
    public void showNotification(int n) {
        this.updateSlide();
        this.displayDelay = n * 1000;
        this.slideIn();
    }

    @Override
    public void showNotification(AnimatingType animatingType, int n) {
        this.animatingType = animatingType;
        this.locate();
        this.showNotification(n);
    }

    @Override
    public void showNotification(AnimatingType animatingType, int n, int n2, int n3) {
        this.animatingType = animatingType;
        this.setLocation(n, n2);
        this.showNotification(n3);
    }

    @Override
    public void showNotification(AnimatingType animatingType, int n, NotificationType notificationType) {
        this.animatingType = animatingType;
        this.locate();
        this.showNotification(n, notificationType);
    }

    @Override
    public void showNotification(AnimatingType animatingType, int n, int n2, int n3, NotificationType notificationType) {
        this.animatingType = animatingType;
        this.setLocation(n, n2);
        this.showNotification(n3, notificationType);
    }

    public AnimatingType getAnimatingType() {
        return this.animatingType;
    }

    public void setAnimatingType(AnimatingType animatingType) {
        this.animatingType = animatingType;
    }

    boolean isOutAnimatingDirection() {
        return this.animatingDirection == -1;
    }

    public boolean isHorizontalSlide() {
        return this.animatingType.equals((Object)AnimatingType.SLIDE_LEFT) || this.animatingType.equals((Object)AnimatingType.SLIDE_RIGHT);
    }

    public boolean isVerticalSlide() {
        return this.animatingType.equals((Object)AnimatingType.SLIDE_TOP) || this.animatingType.equals((Object)AnimatingType.SLIDE_BOTTOM);
    }

    private int calculateProgress(long l) {
        float f = (float)l / 2000.0f;
        int n = (int)((double)f * (this.isVerticalSlide() ? this.tempWindowSize.getHeight() : this.tempWindowSize.getWidth()));
        return Math.max(n, 1);
    }

    private class SlideHoldActionListener
    implements ActionListener {
        private SlideHoldActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (System.currentTimeMillis() > BaseSlideNotificationWindow.this.animationStart && !BaseSlideNotificationWindow.this.interrupted) {
                boolean bl;
                BaseSlideNotificationWindow.this.animationTimer.stop();
                BaseSlideNotificationWindow.this.animationTimer = null;
                boolean bl2 = BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_LEFT) ? BaseSlideNotificationWindow.this.getX() + BaseSlideNotificationWindow.this.getWidth() == BaseSlideNotificationWindow.this.showX : (bl = BaseSlideNotificationWindow.this.getX() == BaseSlideNotificationWindow.this.showX);
                if (!bl) {
                    BaseSlideNotificationWindow.super.hideNotification();
                } else if (BaseSlideNotificationWindow.this.isVisible()) {
                    BaseSlideNotificationWindow.this.slideOut();
                }
            }
        }
    }

    private class SlideOutActionListener
    extends BaseSlideActionListener {
        public SlideOutActionListener(long l, long l2) {
            super(l, l2);
        }

        @Override
        protected void doAnimation(long l) {
            int n = BaseSlideNotificationWindow.this.calculateProgress(l);
            if (BaseSlideNotificationWindow.this.isVerticalSlide()) {
                BaseSlideNotificationWindow.this.animatingPanel.setAnimatingHeight(((BaseSlideNotificationWindow)BaseSlideNotificationWindow.this).tempWindowSize.getSize().height - n);
            } else {
                BaseSlideNotificationWindow.this.animatingPanel.setAnimatingWidth(((BaseSlideNotificationWindow)BaseSlideNotificationWindow.this).tempWindowSize.getSize().width - n);
            }
            BaseSlideNotificationWindow.this.pack();
            if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_BOTTOM)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX, BaseSlideNotificationWindow.this.startY + n);
            } else if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_TOP)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX, BaseSlideNotificationWindow.this.startY);
            } else if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_RIGHT)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX, BaseSlideNotificationWindow.this.startY);
            } else if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_LEFT)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX + n, BaseSlideNotificationWindow.this.startY);
            }
            BaseSlideNotificationWindow.this.setVisible(true);
            BaseSlideNotificationWindow.this.repaint();
        }

        @Override
        protected void finishAnimation() {
            BaseSlideNotificationWindow.this.setVisible(false);
            BaseSlideNotificationWindow.this.animationTimer.stop();
            BaseSlideNotificationWindow.this.animationTimer = null;
        }
    }

    private class SlideInActionListener
    extends BaseSlideActionListener {
        public SlideInActionListener(long l, long l2) {
            super(l, l2);
        }

        @Override
        protected void finishAnimation() {
            BaseSlideNotificationWindow.this.getContentPane().removeAll();
            BaseSlideNotificationWindow.this.setContentPane(BaseSlideNotificationWindow.this.contentPanel);
            this.updateAnimation();
            BaseSlideNotificationWindow.this.animationTimer.stop();
            BaseSlideNotificationWindow.this.animationTimer = null;
            if (BaseSlideNotificationWindow.this.isVisible()) {
                BaseSlideNotificationWindow.this.slideHold();
            }
        }

        @Override
        protected void doAnimation(long l) {
            int n = BaseSlideNotificationWindow.this.calculateProgress(l);
            if (BaseSlideNotificationWindow.this.isVerticalSlide()) {
                BaseSlideNotificationWindow.this.animatingPanel.setAnimatingHeight(n);
            } else {
                BaseSlideNotificationWindow.this.animatingPanel.setAnimatingWidth(n);
            }
            this.updateAnimation();
        }

        protected void updateAnimation() {
            BaseSlideNotificationWindow.this.pack();
            if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_BOTTOM)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX, BaseSlideNotificationWindow.this.startY - BaseSlideNotificationWindow.this.getSize().height);
            } else if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_TOP)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX, BaseSlideNotificationWindow.this.startY);
            } else if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_RIGHT)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX, BaseSlideNotificationWindow.this.startY);
            } else if (BaseSlideNotificationWindow.this.animatingType.equals((Object)AnimatingType.SLIDE_LEFT)) {
                BaseSlideNotificationWindow.this.setLocation(BaseSlideNotificationWindow.this.showX - BaseSlideNotificationWindow.this.getSize().width, BaseSlideNotificationWindow.this.startY);
            }
            BaseSlideNotificationWindow.this.setVisible(true);
            BaseSlideNotificationWindow.this.repaint();
        }
    }
}

