/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.modal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.window.BaseNotificationWindow;
import net.sf.amemailchecker.gui.notification.window.modal.IModalNotificationWindow;

public abstract class BaseModalNotificationWindow
extends BaseNotificationWindow
implements IModalNotificationWindow {
    protected Container displayOn;
    protected BoxLayout layout;
    protected JButton actionButton;
    boolean showActionButton = false;
    protected boolean isOnGlass = false;
    protected boolean useLock = true;

    protected BaseModalNotificationWindow(Window window) {
        super(window, window.getGraphicsConfiguration());
        this.displayOn = window;
    }

    protected BaseModalNotificationWindow(Window window, boolean bl) {
        this(window);
        this.showActionButton = bl;
    }

    protected BaseModalNotificationWindow(Window window, boolean bl, boolean bl2) {
        this(window, bl);
        this.useLock = bl2;
    }

    @Override
    protected void init() {
        super.init();
        this.setAlwaysOnTop(false);
    }

    @Override
    protected void construct() {
        this.contentPanel.setAlignmentX(0.5f);
        this.layout = new BoxLayout(this.contentPanel, 1);
        this.contentPanel.setLayout(this.layout);
        this.updateLook(NotificationType.INFO);
    }

    @Override
    protected void locate() {
        Point point = this.displayOn.getLocationOnScreen();
        Dimension dimension = this.displayOn.getSize();
        this.setLocation(point.x + (dimension.width - this.getSize().width) / 2, point.y + (dimension.height - this.getSize().height) / 2);
    }

    protected void constructActionButton() {
        this.actionButton = new JButton();
        this.actionButton.setText("Close");
        this.actionButton.setContentAreaFilled(false);
        this.actionButton.setMargin(new Insets(0, 10, 0, 10));
        this.actionButton.setFont(new Font("Serif", 0, 10));
    }

    public void setActionButtonText(String string) {
        if (this.showActionButton) {
            this.actionButton.setText(string);
            this.pack();
            this.setSize();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionButton.addActionListener(actionListener);
    }

    public void addAction(Action action) {
        this.actionButton.setAction(action);
    }

    public void setVisibleOnGlass(boolean bl) {
        this.isOnGlass = bl;
        if (!(this.displayOn instanceof JFrame) && !(this.displayOn instanceof JDialog)) {
            throw new IllegalArgumentException("Container to display is not an appropriate instance!");
        }
        JPanel jPanel = this.displayOn instanceof JFrame ? (JPanel)((JFrame)this.displayOn).getGlassPane() : (JPanel)((JDialog)this.displayOn).getGlassPane();
        if (!bl) {
            jPanel.removeAll();
        } else {
            jPanel.setBackground(new Color(255, 255, 255, 125));
            jPanel.setLayout(new GridBagLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.contentPanel);
            jPanel.add(jPanel2);
            jPanel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
        }
        jPanel.setOpaque(bl);
        jPanel.setVisible(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.useLock) {
            this.displayOn.setEnabled(!bl);
            this.displayOn.setFocusable(!bl);
        }
        super.setVisible(bl);
        this.setFocusableWindowState(false);
    }

    @Override
    public void showNotificationOnGlass() {
        this.setVisibleOnGlass(true);
    }

    @Override
    public void showNotificationOnGlass(NotificationType notificationType) {
        this.updateLook(notificationType);
        this.showNotificationOnGlass();
    }

    @Override
    public void hideNotification() {
        if (this.isOnGlass) {
            this.setVisibleOnGlass(false);
        } else {
            super.hideNotification();
        }
    }
}

