/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.modal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.amemailchecker.gui.notification.MovableMouseListener;
import net.sf.amemailchecker.gui.notification.window.modal.BaseModalNotificationWindow;

public abstract class CaptionedNotificationWindow
extends BaseModalNotificationWindow {
    public CaptionedNotificationWindow(Window window) {
        super(window, true, false);
    }

    @Override
    protected void construct() {
        CaptionMouseListener captionMouseListener = new CaptionMouseListener(this);
        this.addMouseListener(captionMouseListener);
        this.addMouseMotionListener(captionMouseListener);
        this.setContentPane(new ContentPane());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
    }

    public void setContent(JComponent jComponent) {
        this.contentPanel.add(jComponent);
    }

    private class ContentPane
    extends JPanel {
        private ContentPane() {
            this.setLayout(new BorderLayout());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.translate(this.getX(), this.getY());
            graphics.translate(this.getX(), this.getY());
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), 15);
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fill(rectangle);
            int n = this.getHeight() - 1;
            int n2 = this.getWidth() - 1;
            graphics.drawLine(this.getX(), this.getY() + 15, this.getX(), this.getHeight());
            graphics.drawLine(this.getX(), n, this.getWidth(), n);
            graphics.drawLine(n2, n, n2, this.getY() + 15);
        }

        @Override
        public Insets getInsets() {
            return new Insets(20, 10, 10, 10);
        }
    }

    private class CaptionMouseListener
    extends MovableMouseListener {
        public CaptionMouseListener(Component component) {
            super(component);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.inArea(mouseEvent.getPoint())) {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.inArea(mouseEvent.getPoint())) {
                super.mouseDragged(mouseEvent);
            }
        }

        private boolean inArea(Point point) {
            return point.getY() < 15.0;
        }
    }
}

