/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.modal;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.amemailchecker.gui.notification.panel.ExtendedInfoPanel;
import net.sf.amemailchecker.gui.notification.window.modal.CaptionedNotificationWindow;

public class MultipleNotificationWindow
extends CaptionedNotificationWindow {
    private List<ExtendedInfoPanel> notifications = new ArrayList<ExtendedInfoPanel>();
    private JLabel emptyMessage;

    public MultipleNotificationWindow(Window window) {
        super(window);
        this.construct();
    }

    @Override
    protected void construct() {
        super.construct();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.contentPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.constructActionButton();
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleNotificationWindow.this.notifications.clear();
                MultipleNotificationWindow.this.contentPanel.removeAll();
                MultipleNotificationWindow.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.actionButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.emptyMessage = new JLabel();
        this.emptyMessage.setAlignmentX(0.5f);
        this.emptyMessage.setHorizontalAlignment(0);
        this.emptyMessage.setAlignmentY(0.5f);
        this.emptyMessage.setVerticalAlignment(0);
    }

    @Override
    public void setVisible(boolean bl) {
        if (!this.containsNotifications()) {
            this.contentPanel.add(this.emptyMessage);
        }
        this.setSize(400, 300);
        this.locate();
        super.setVisible(bl);
    }

    public void addNotification(String string, String string2) {
        ExtendedInfoPanel extendedInfoPanel = new ExtendedInfoPanel(string, string2);
        extendedInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.notifications.add(extendedInfoPanel);
        this.contentPanel.add(extendedInfoPanel);
    }

    public boolean containsNotifications() {
        return this.notifications.size() > 0;
    }

    public int getNotificationsSize() {
        return this.notifications.size();
    }

    public void setEmptyMessage(String string) {
        this.emptyMessage.setText(string);
    }
}

