/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.modal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.amemailchecker.gui.notification.widget.SpinWidget;
import net.sf.amemailchecker.gui.notification.window.modal.BaseSystemNotificationWindow;

public class SystemNotificationExtendedInfoWindow
extends BaseSystemNotificationWindow {
    private String detailedMessage;
    private JTextArea detailedMessageComponent;
    private JScrollPane detailedScroll;
    private SpinWidget spinWidget;

    public SystemNotificationExtendedInfoWindow(String string, String string2, Window window) {
        super(string, window);
        this.detailedMessage = string2;
        this.init();
    }

    @Override
    protected void construct() {
        super.construct();
        this.detailedMessageComponent = new JTextArea();
        this.detailedMessageComponent.setLineWrap(true);
        this.detailedMessageComponent.setText(this.detailedMessage);
        this.detailedMessageComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.WHITE), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.detailedScroll = new JScrollPane();
        this.detailedScroll.setHorizontalScrollBarPolicy(31);
        this.detailedScroll.setVerticalScrollBarPolicy(20);
        this.detailedScroll.getViewport().add(this.detailedMessageComponent);
        this.spinWidget = new SpinWidget();
        this.spinWidget.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SystemNotificationExtendedInfoWindow.this.resetBottomVisibility(SystemNotificationExtendedInfoWindow.this.spinWidget.isExpanded());
            }
        });
        this.contentPanel.add(this.linesPanel);
        this.contentPanel.add(Box.createVerticalStrut(10));
        this.contentPanel.add(this.buttonPanel);
        this.contentPanel.add(Box.createVerticalStrut(5));
        this.contentPanel.add(this.spinWidget);
        this.contentPanel.add(Box.createVerticalStrut(5));
        this.contentPanel.add(this.detailedScroll);
        this.resetBottomVisibility(false);
    }

    private void resetBottomVisibility(boolean bl) {
        this.detailedScroll.setVisible(bl);
        this.contentPanel.revalidate();
        if (this.isShowing()) {
            this.setSize();
            this.pack();
            this.contentPanel.repaint();
        }
        if (this.isOnGlass) {
            this.displayOn.validate();
            this.displayOn.repaint();
        }
        this.detailedScroll.getViewport().revalidate();
    }

    @Override
    protected void setSize() {
        super.setSize();
        int n = this.getFontMetrics(this.getFont()).stringWidth(this.message);
        int n2 = this.displayOn.getWidth() / 3;
        this.setSize(n > n2 ? n + 50 : n2, this.getSize().height);
        this.setPreferredSize(this.getSize());
        this.detailedScroll.setPreferredSize(new Dimension(this.getWidth() - 10, (int)this.getLayout().preferredLayoutSize(this.detailedMessageComponent).getHeight()));
    }
}

