/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.tooltip;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Timer;
import net.sf.amemailchecker.gui.notification.window.tooltip.ToolTipNotificationWindow;

public class ToolTipMouseListener
extends MouseAdapter
implements MouseMotionListener {
    private ToolTipNotificationWindow currentTip;
    private Configuration configuration;
    private Timer enterTimer;
    private Point currentPoint;

    public ToolTipMouseListener(Configuration configuration) {
        this.configuration = configuration;
        this.enterTimer = new Timer(configuration.getDisplayDelay() * 500, new ShowTipTimerAction());
        this.enterTimer.setRepeats(false);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.currentPoint = mouseEvent.getLocationOnScreen();
        if (!this.enterTimer.isRunning()) {
            this.enterTimer.start();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.hideTip();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTip();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.currentPoint = mouseEvent.getLocationOnScreen();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    private void showTip() {
        this.currentTip = new ToolTipNotificationWindow(this.configuration.getMessage(), this.configuration.getInvoker());
        this.currentTip.setLocation(this.currentPoint);
        this.currentTip.showNotification();
    }

    private void hideTip() {
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.currentTip != null) {
            this.currentTip.hideNotification();
        }
    }

    public static class Configuration {
        private int displayDelay;
        private String message;
        private Component invoker;

        public Configuration(int n, String string, Component component) {
            this.displayDelay = n;
            this.message = string;
            this.invoker = component;
        }

        public int getDisplayDelay() {
            return this.displayDelay;
        }

        public void setDisplayDelay(int n) {
            this.displayDelay = n;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public Component getInvoker() {
            return this.invoker;
        }

        public void setInvoker(Component component) {
            this.invoker = component;
        }
    }

    private class ShowTipTimerAction
    implements ActionListener {
        private ShowTipTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipMouseListener.this.showTip();
        }
    }
}

