/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.window.tooltip;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import javax.swing.BorderFactory;
import net.sf.amemailchecker.gui.notification.panel.TextMultiLinePanel;
import net.sf.amemailchecker.gui.notification.window.BaseNotificationWindow;

public class ToolTipNotificationWindow
extends BaseNotificationWindow {
    private Component component;
    private String message;

    public ToolTipNotificationWindow(String string, Component component) {
        this.message = string;
        this.component = component;
        this.init();
    }

    @Override
    protected void construct() {
        this.contentPanel.setBackground(theme.getDefaultBackgroundColor());
        this.contentPanel.setBorder(BorderFactory.createLineBorder(theme.getDefaultBorderColor()));
        this.contentPanel.setLayout(new FlowLayout(1));
        if (this.message != null) {
            this.contentPanel.add(new TextMultiLinePanel(this.message, false));
        }
    }

    @Override
    protected void locate() {
        Point point = this.component.getLocationOnScreen();
        Dimension dimension = this.component.getSize();
        this.setLocation((int)(point.getX() + dimension.getWidth() / 2.0), (int)(point.getY() + dimension.getHeight() / 2.0));
    }

    public void showNotification(String string) {
        this.message = string;
        this.contentPanel.removeAll();
        this.construct();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        super.showNotification();
    }
}

