/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import net.sf.amemailchecker.gui.HighlightMouseListener;

public enum ActionControlFactory {
    Factory;


    public JButton createSimpleActionButton(ImageIcon imageIcon) {
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    public JButton constructActionPanelButton(String string, ImageIcon imageIcon) {
        return (JButton)this.constructActionPanelButton(new JButton(), string, imageIcon);
    }

    public AbstractButton constructActionPanelButton(AbstractButton abstractButton, String string, ImageIcon imageIcon) {
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        abstractButton.setToolTipText(string);
        abstractButton.setIcon(imageIcon);
        return abstractButton;
    }

    public JButton createLinkButton() {
        JButton jButton = new JButton();
        jButton.setHorizontalAlignment(0);
        jButton.setVerticalTextPosition(0);
        jButton.setBorderPainted(false);
        jButton.setForeground(Color.BLUE);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setFocusPainted(false);
        jButton.setRequestFocusEnabled(false);
        jButton.setContentAreaFilled(false);
        jButton.addMouseListener(new HighlightMouseListener());
        return jButton;
    }

    public JPanel createTitleWrapper(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.add(jComponent);
        return jPanel;
    }

    public JScrollPane createScrollWrapper(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jComponent);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        return jScrollPane;
    }

    public JMenuItem getJMenuItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public MenuItem getMenuItem(String string, ActionListener actionListener) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    public JTextPane getTextPane(StyledDocument styledDocument, Font font) {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setDocument(styledDocument);
        this.setTextComponent(jTextPane, font);
        return jTextPane;
    }

    public JTextArea getTextArea(Document document, Font font) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setDocument(document);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        this.setTextComponent(jTextArea, font);
        return jTextArea;
    }

    private void setTextComponent(JTextComponent jTextComponent, Font font) {
        jTextComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jTextComponent.setFont(font != null ? font : jTextComponent.getFont());
    }
}

