/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.amemailchecker.app.ResourceContext;

public abstract class BaseDialog
extends JDialog {
    protected JPanel commonButtonPanel;
    protected JButton cancel;
    protected JButton accept;
    private boolean modal;
    private JDialog invoker;

    public void init(ResourceContext resourceContext) {
        this.commonButtonPanel = new JPanel();
        this.cancel = new JButton();
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseDialog.this.setVisible(false);
            }
        });
        this.accept = new JButton();
        this.commonButtonPanel.add(this.accept);
        this.commonButtonPanel.add(this.cancel);
        this.setIconImage(resourceContext.loadImageIcon("icon.logo").getImage());
        super.setTitle(resourceContext.getI18NBundleValue("about.program.name"));
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BaseDialog.this.setVisible(false);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(this.getTitle() + " [ " + string + " ]");
    }

    protected void setAutoSize(Container container) {
        Dimension dimension = container.getSize();
        this.setSize(dimension.width - 100, dimension.height - 100);
        this.setAutoLocation();
    }

    protected void setAutoLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.setAutoLocation();
    }

    public BaseDialog() {
    }

    public BaseDialog(JDialog jDialog, boolean bl) {
        super(jDialog);
        this.invoker = jDialog;
        this.modal = bl;
        this.setAutoSize(jDialog);
    }

    public BaseDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.setAutoSize(jFrame);
    }

    public BaseDialog(Window window) {
        super(window, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setAutoSize(window);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.modal) {
            this.invoker.setEnabled(!bl);
            this.invoker.setFocusable(!bl);
        }
        super.setVisible(bl);
    }
}

