/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Scanner;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptoValueProceeder {
    public static final String AES = "AES";

    public static void createKeyFile(File file) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(AES);
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(CryptoValueProceeder.byteArrayToHexString(secretKey.getEncoded()));
        fileWriter.flush();
        fileWriter.close();
    }

    public static String encodePassword(char[] cArray, File file) throws Exception {
        if (cArray == null) {
            throw new IllegalArgumentException("password is NULL");
        }
        if (!file.exists()) {
            CryptoValueProceeder.createKeyFile(file);
        }
        SecretKeySpec secretKeySpec = CryptoValueProceeder.getSecretKeySpec(file);
        Cipher cipher = Cipher.getInstance(AES);
        cipher.init(1, (Key)secretKeySpec, cipher.getParameters());
        byte[] byArray = cipher.doFinal(new String(cArray).getBytes());
        return CryptoValueProceeder.byteArrayToHexString(byArray);
    }

    public static char[] decodePassword(String string, File file) throws Exception {
        SecretKeySpec secretKeySpec = CryptoValueProceeder.getSecretKeySpec(file);
        Cipher cipher = Cipher.getInstance(AES);
        cipher.init(2, secretKeySpec);
        byte[] byArray = cipher.doFinal(CryptoValueProceeder.hexStringToByteArray(string));
        return new String(byArray).toCharArray();
    }

    private static SecretKeySpec getSecretKeySpec(File file) throws NoSuchAlgorithmException, IOException {
        byte[] byArray = CryptoValueProceeder.readKeyFile(file);
        return new SecretKeySpec(byArray, AES);
    }

    private static byte[] readKeyFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file).useDelimiter("\\Z");
        String string = scanner.next();
        scanner.close();
        return CryptoValueProceeder.hexStringToByteArray(string);
    }

    private static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    private static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i * 2;
            int n2 = Integer.parseInt(string.substring(n, n + 2), 16);
            byArray[i] = (byte)n2;
        }
        return byArray;
    }
}

