/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.util;

import java.util.Vector;
import net.sf.amemailchecker.util.GenericObserver;

public abstract class GenericObservable<T> {
    private boolean changed;
    private Vector<GenericObserver<T>> observers = new Vector();

    public synchronized void addObserver(GenericObserver<T> genericObserver) {
        if (genericObserver == null) {
            throw new NullPointerException();
        }
        if (!this.observers.contains(genericObserver)) {
            this.observers.addElement(genericObserver);
        }
    }

    public synchronized void deleteObserver(GenericObserver<T> genericObserver) {
        this.observers.removeElement(genericObserver);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public synchronized void notifyObservers(T t) {
        if (!this.changed) {
            return;
        }
        for (GenericObserver<T> genericObserver : this.observers) {
            genericObserver.updatePerformed(t);
        }
        this.clearChanged();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }
}

