/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.util;

import java.util.Arrays;
import java.util.List;

public final class StringUtil {
    private StringUtil() {
    }

    public static String trimWith(String string, String string2, String string3) {
        boolean bl = string.startsWith(string2);
        boolean bl2 = string.endsWith(string3);
        if (!bl && !bl2) {
            return string;
        }
        int n = bl ? string2.length() : 0;
        int n2 = bl2 ? string.length() - string3.length() : string.length();
        return string.substring(n, n2);
    }

    public static String appendTokens(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String appendTokensDelimiter(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            stringBuilder.append(string2);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String appendTokensTerminate(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            boolean bl = string2.endsWith(string);
            if (bl) {
                string2 = StringUtil.trimWith(string2, "", "=");
            }
            stringBuilder.append(string2);
            if (bl) continue;
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public static List<String> dropToTokens(String string, String string2) {
        return Arrays.asList(string.split(string2));
    }

    public static String trimWithDoubleQuote(String string) {
        return StringUtil.trimWith(string.trim(), "\"", "\"");
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return string.toLowerCase().indexOf(string2.toLowerCase());
    }

    public static String wrapIfNull(String string) {
        return string == null ? "" : string;
    }

    public static String wrapIfNullAndEncapsulate(String string, String string2, String string3) {
        return string == null ? "" : string2 + string + string3;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public static boolean containsNonAsciiChars(String string) {
        char[] cArray;
        if (string == null || string.equals("")) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            if (StringUtil.isAscii(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAscii(char c) {
        return c <= '\u007f';
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.equals("");
    }
}

