/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.util.iterator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import net.sf.amemailchecker.util.iterator.TreeGraphHierarchyIterator;

public abstract class DefaultTreeGraphHierarchyIterator<T>
implements TreeGraphHierarchyIterator<T> {
    private final Stack<TreeGraphHierarchyIterator> iterators = new Stack();
    private T next;
    private T parent;
    private Collection<T> elements;

    public DefaultTreeGraphHierarchyIterator(T ... TArray) {
        this((Collection<T>)Arrays.asList(TArray));
    }

    public DefaultTreeGraphHierarchyIterator(Collection<T> collection) {
        this.elements = collection;
        this.reset();
    }

    @Override
    public T next() {
        return this.next;
    }

    @Override
    public boolean hasNext() {
        this.moveToNext();
        return this.next != null;
    }

    @Override
    public T parent() {
        return this.parent;
    }

    @Override
    public void reset() {
        this.iterators.clear();
        this.iterators.push(new TreeNodeIterator<Object>(null, this.elements));
    }

    private void moveToNext() {
        this.next = null;
        this.parent = null;
        if (!this.iterators.empty()) {
            if (!this.iterators.peek().hasNext()) {
                this.iterators.pop();
                this.moveToNext();
            } else {
                TreeGraphHierarchyIterator treeGraphHierarchyIterator = this.iterators.peek();
                Object t = treeGraphHierarchyIterator.next();
                Object t2 = treeGraphHierarchyIterator.parent();
                if (t instanceof DefaultTreeGraphHierarchyIterator) {
                    this.iterators.push((DefaultTreeGraphHierarchyIterator)t);
                    this.moveToNext();
                } else {
                    this.parent = t2;
                    this.next = t;
                }
            }
        }
    }

    public abstract Collection children(Object var1);

    private class TreeNodeIterator<T>
    implements TreeGraphHierarchyIterator<T> {
        private T parent;
        private Iterator<T> iterator;
        private T current;
        private Collection<T> elements;

        public TreeNodeIterator(T t, Collection<T> collection) {
            this.elements = collection;
            this.parent = t;
            this.iterator = collection.iterator();
        }

        @Override
        public T next() {
            this.current = this.iterator.next();
            DefaultTreeGraphHierarchyIterator.this.iterators.push(new TreeNodeIterator<T>(this.current, DefaultTreeGraphHierarchyIterator.this.children(this.current)));
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T parent() {
            return this.parent;
        }

        @Override
        public void reset() {
            this.iterator = this.elements.iterator();
            this.current = null;
        }
    }
}

