--DROP TABLE AMC.POP3_MARKED_READ_CACHE IF EXISTS;
--DROP TABLE AMC.LETTER_HEADERS IF EXISTS;
--DROP TABLE AMC.LETTER IF EXISTS;
--DROP SCHEMA AMC CASCADE IF EXISTS;

CREATE SCHEMA AMC;

CREATE TABLE AMC.ACCOUNT (
    UUID VARCHAR(64) NOT NULL PRIMARY KEY
);

CREATE TABLE AMC.FOLDER (
    UUID VARCHAR(64) NOT NULL PRIMARY KEY,
    ACCOUNT_UUID VARCHAR(64) NOT NULL,
    FOLDER_LABEL VARCHAR(128) NOT NULL,
    CREATED_DATE TIMESTAMP NOT NULL,
    CONSTRAINT FK_F_ACCOUNT_UUID FOREIGN KEY (ACCOUNT_UUID)
        REFERENCES ACCOUNT (UUID) ON DELETE CASCADE
);

CREATE TABLE AMC.FOLDER_REL (
    PARENT_UUID VARCHAR(64),
    CHILD_UUID VARCHAR(64) NOT NULL,
    CONSTRAINT FK_FR_CHILD_UUID FOREIGN KEY (CHILD_UUID)
        REFERENCES FOLDER (UUID) ON DELETE CASCADE
);

CREATE TABLE AMC.POP3_MARKED_READ_CACHE (
    ACCOUNT_UID VARCHAR(64) NOT NULL,
    MESSAGE_UID VARCHAR(128) NOT NULL
);

CREATE TABLE AMC.LETTER (
    ID BIGINT NOT NULL PRIMARY KEY IDENTITY,
    FOLDER_UUID VARCHAR(64) NOT NULL,
    MESSAGE_UID VARCHAR(128) NOT NULL,
    MESSAGE_ID VARCHAR(512) NOT NULL,
    SUBJECT VARCHAR(1024),
    DATE_RECEIVED TIMESTAMP,
    CONSTRAINT FK_L_FOLDER_UUID FOREIGN KEY (FOLDER_UUID)
        REFERENCES FOLDER (UUID) ON DELETE CASCADE
);

CREATE TABLE AMC.LETTER_PART (
    ID BIGINT NOT NULL PRIMARY KEY IDENTITY,
    LETTER_ID INTEGER NOT NULL,
    PAYLOAD CLOB,
    CONSTRAINT FK_LP_LETTER_ID FOREIGN KEY (LETTER_ID)
      REFERENCES LETTER (ID) ON DELETE CASCADE
);

CREATE TABLE AMC.LETTER_PART_REL (
    PARENT_ID BIGINT,
    CHILD_ID BIGINT NOT NULL,
    CONSTRAINT FK_LPR_PART_ID FOREIGN KEY (CHILD_ID)
      REFERENCES LETTER_PART (ID) ON DELETE CASCADE
);

CREATE TABLE AMC.PART_HEADER (
    ID BIGINT NOT NULL PRIMARY KEY IDENTITY,
    LETTER_PART_ID BIGINT NOT NULL,
    HEADER_NAME VARCHAR(256),
    HEADER_VALUE VARCHAR(1024),
    CONSTRAINT FK_PHL_PART_ID FOREIGN KEY (LETTER_PART_ID)
      REFERENCES LETTER_PART (ID) ON DELETE CASCADE
);
