DROP TABLE IF EXISTS `<DB_PREFIX>country_translations`;
CREATE TABLE IF NOT EXISTS `<DB_PREFIX>country_translations` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `country_code` varchar(2) CHARACTER SET latin1 NOT NULL,
  `language_code` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT 'en',
  `name` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `country_code` (`country_code`),
  KEY `language_code` (`language_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=715 ;

INSERT INTO `<DB_PREFIX>country_translations` (`id`, `country_code`, `language_code`, `name`) VALUES
(1, 'AF', 'en', 'Afghanistan'),
(2, 'AL', 'en', 'Albania'),
(3, 'DZ', 'en', 'Algeria'),
(4, 'AS', 'en', 'American Samoa'),
(5, 'AD', 'en', 'Andorra'),
(6, 'AO', 'en', 'Angola'),
(7, 'AI', 'en', 'Anguilla'),
(8, 'AQ', 'en', 'Antarctica'),
(9, 'AG', 'en', 'Antigua and Barbuda'),
(10, 'AR', 'en', 'Argentina'),
(11, 'AM', 'en', 'Armenia'),
(12, 'AW', 'en', 'Aruba'),
(13, 'AU', 'en', 'Australia'),
(14, 'AT', 'en', 'Austria'),
(15, 'AZ', 'en', 'Azerbaijan'),
(16, 'BS', 'en', 'Bahamas'),
(17, 'BH', 'en', 'Bahrain'),
(18, 'BD', 'en', 'Bangladesh'),
(19, 'BB', 'en', 'Barbados'),
(20, 'BY', 'en', 'Belarus'),
(21, 'BE', 'en', 'Belgium'),
(22, 'BZ', 'en', 'Belize'),
(23, 'BJ', 'en', 'Benin'),
(24, 'BM', 'en', 'Bermuda'),
(25, 'BT', 'en', 'Bhutan'),
(26, 'BO', 'en', 'Bolivia'),
(27, 'BA', 'en', 'Bosnia and Herzegowina'),
(28, 'BW', 'en', 'Botswana'),
(29, 'BV', 'en', 'Bouvet Island'),
(30, 'BR', 'en', 'Brazil'),
(31, 'IO', 'en', 'British Indian Ocean Territory'),
(32, 'VG', 'en', 'British Virgin Islands'),
(33, 'BN', 'en', 'Brunei Darussalam'),
(34, 'BG', 'en', 'Bulgaria'),
(35, 'BF', 'en', 'Burkina Faso'),
(36, 'BI', 'en', 'Burundi'),
(37, 'KH', 'en', 'Cambodia'),
(38, 'CM', 'en', 'Cameroon'),
(39, 'CA', 'en', 'Canada'),
(40, 'CV', 'en', 'Cape Verde'),
(41, 'KY', 'en', 'Cayman Islands'),
(42, 'CF', 'en', 'Central African Republic'),
(43, 'TD', 'en', 'Chad'),
(44, 'CL', 'en', 'Chile'),
(45, 'CN', 'en', 'China'),
(46, 'CX', 'en', 'Christmas Island'),
(47, 'CC', 'en', 'Cocos (Keeling) Islands'),
(48, 'CO', 'en', 'Colombia'),
(49, 'KM', 'en', 'Comoros'),
(50, 'CG', 'en', 'Congo'),
(51, 'CK', 'en', 'Cook Islands'),
(52, 'CR', 'en', 'Costa Rica'),
(53, 'CI', 'en', 'Cote D''ivoire'),
(54, 'HR', 'en', 'Croatia'),
(55, 'CU', 'en', 'Cuba'),
(56, 'CY', 'en', 'Cyprus'),
(57, 'CZ', 'en', 'Czech Republic'),
(58, 'DK', 'en', 'Denmark'),
(59, 'DJ', 'en', 'Djibouti'),
(60, 'DM', 'en', 'Dominica'),
(61, 'DO', 'en', 'Dominican Republic'),
(62, 'TP', 'en', 'East Timor'),
(63, 'EC', 'en', 'Ecuador'),
(64, 'EG', 'en', 'Egypt'),
(65, 'SV', 'en', 'El Salvador'),
(66, 'GQ', 'en', 'Equatorial Guinea'),
(67, 'ER', 'en', 'Eritrea'),
(68, 'EE', 'en', 'Estonia'),
(69, 'ET', 'en', 'Ethiopia'),
(70, 'FK', 'en', 'Falkland Islands (Malvinas)'),
(71, 'FO', 'en', 'Faroe Islands'),
(72, 'FJ', 'en', 'Fiji'),
(73, 'FI', 'en', 'Finland'),
(74, 'FR', 'en', 'France'),
(75, 'GF', 'en', 'French Guiana'),
(76, 'PF', 'en', 'French Polynesia'),
(77, 'TF', 'en', 'French Southern Territories'),
(78, 'GA', 'en', 'Gabon'),
(79, 'GM', 'en', 'Gambia'),
(80, 'GE', 'en', 'Georgia'),
(81, 'DE', 'en', 'Germany'),
(82, 'GH', 'en', 'Ghana'),
(83, 'GI', 'en', 'Gibraltar'),
(84, 'GR', 'en', 'Greece'),
(85, 'GL', 'en', 'Greenland'),
(86, 'GD', 'en', 'Grenada'),
(87, 'GP', 'en', 'Guadeloupe'),
(88, 'GU', 'en', 'Guam'),
(89, 'GT', 'en', 'Guatemala'),
(90, 'GN', 'en', 'Guinea'),
(91, 'GW', 'en', 'Guinea-Bissau'),
(92, 'GY', 'en', 'Guyana'),
(93, 'HT', 'en', 'Haiti'),
(94, 'HM', 'en', 'Heard and McDonald Islands'),
(95, 'HN', 'en', 'Honduras'),
(96, 'HK', 'en', 'Hong Kong'),
(97, 'HU', 'en', 'Hungary'),
(98, 'IS', 'en', 'Iceland'),
(99, 'IN', 'en', 'India'),
(100, 'ID', 'en', 'Indonesia'),
(101, 'IQ', 'en', 'Iraq'),
(102, 'IE', 'en', 'Ireland'),
(103, 'IR', 'en', 'Islamic Republic of Iran'),
(104, 'IL', 'en', 'Israel'),
(105, 'IT', 'en', 'Italy'),
(106, 'JM', 'en', 'Jamaica'),
(107, 'JP', 'en', 'Japan'),
(108, 'JO', 'en', 'Jordan'),
(109, 'KZ', 'en', 'Kazakhstan'),
(110, 'KE', 'en', 'Kenya'),
(111, 'KI', 'en', 'Kiribati'),
(112, 'KP', 'en', 'Democratic People''s Republic of Korea'),
(113, 'KR', 'en', 'Korea, Republic of'),
(114, 'KW', 'en', 'Kuwait'),
(115, 'KG', 'en', 'Kyrgyzstan'),
(116, 'LA', 'en', 'Laos'),
(117, 'LV', 'en', 'Latvia'),
(118, 'LB', 'en', 'Lebanon'),
(119, 'LS', 'en', 'Lesotho'),
(120, 'LR', 'en', 'Liberia'),
(121, 'LY', 'en', 'Libya'),
(122, 'LI', 'en', 'Liechtenstein'),
(123, 'LT', 'en', 'Lithuania'),
(124, 'LU', 'en', 'Luxembourg'),
(125, 'MO', 'en', 'Macau'),
(126, 'MK', 'en', 'Macedonia'),
(127, 'MG', 'en', 'Madagascar'),
(128, 'MW', 'en', 'Malawi'),
(129, 'MY', 'en', 'Malaysia'),
(130, 'MV', 'en', 'Maldives'),
(131, 'ML', 'en', 'Mali'),
(132, 'MT', 'en', 'Malta'),
(133, 'MH', 'en', 'Marshall Islands'),
(134, 'MQ', 'en', 'Martinique'),
(135, 'MR', 'en', 'Mauritania'),
(136, 'MU', 'en', 'Mauritius'),
(137, 'YT', 'en', 'Mayotte'),
(138, 'MX', 'en', 'Mexico'),
(139, 'FM', 'en', 'Micronesia'),
(140, 'MD', 'en', 'Moldova, Republic of'),
(141, 'MC', 'en', 'Monaco'),
(142, 'MN', 'en', 'Mongolia'),
(143, 'MS', 'en', 'Montserrat'),
(144, 'MA', 'en', 'Morocco'),
(145, 'MZ', 'en', 'Mozambique'),
(146, 'MM', 'en', 'Myanmar'),
(147, 'NA', 'en', 'Namibia'),
(148, 'NR', 'en', 'Nauru'),
(149, 'NP', 'en', 'Nepal'),
(150, 'NL', 'en', 'Netherlands'),
(151, 'AN', 'en', 'Netherlands Antilles'),
(152, 'NC', 'en', 'New Caledonia'),
(153, 'NZ', 'en', 'New Zealand'),
(154, 'NI', 'en', 'Nicaragua'),
(155, 'NE', 'en', 'Niger'),
(156, 'NG', 'en', 'Nigeria'),
(157, 'NU', 'en', 'Niue'),
(158, 'NF', 'en', 'Norfolk Island'),
(159, 'MP', 'en', 'Northern Mariana Islands'),
(160, 'NO', 'en', 'Norway'),
(161, 'OM', 'en', 'Oman'),
(162, 'PK', 'en', 'Pakistan'),
(163, 'PW', 'en', 'Palau'),
(164, 'PA', 'en', 'Panama'),
(165, 'PG', 'en', 'Papua New Guinea'),
(166, 'PY', 'en', 'Paraguay'),
(167, 'PE', 'en', 'Peru'),
(168, 'PH', 'en', 'Philippines'),
(169, 'PN', 'en', 'Pitcairn'),
(170, 'PL', 'en', 'Poland'),
(171, 'PT', 'en', 'Portugal'),
(172, 'PR', 'en', 'Puerto Rico'),
(173, 'QA', 'en', 'Qatar'),
(174, 'RE', 'en', 'Reunion'),
(175, 'RO', 'en', 'Romania'),
(176, 'RU', 'en', 'Russian Federation'),
(177, 'RW', 'en', 'Rwanda'),
(178, 'LC', 'en', 'Saint Lucia'),
(179, 'WS', 'en', 'Samoa'),
(180, 'SM', 'en', 'San Marino'),
(181, 'ST', 'en', 'Sao Tome and Principe'),
(182, 'SA', 'en', 'Saudi Arabia'),
(183, 'SN', 'en', 'Senegal'),
(184, 'RS', 'en', 'Republic of Serbia'),
(185, 'SC', 'en', 'Seychelles'),
(186, 'SL', 'en', 'Sierra Leone'),
(187, 'SG', 'en', 'Singapore'),
(188, 'SK', 'en', 'Slovakia'),
(189, 'SI', 'en', 'Slovenia'),
(190, 'SB', 'en', 'Solomon Islands'),
(191, 'SO', 'en', 'Somalia'),
(192, 'ZA', 'en', 'South Africa'),
(193, 'ES', 'en', 'Spain'),
(194, 'LK', 'en', 'Sri Lanka'),
(195, 'SH', 'en', 'St. Helena'),
(196, 'KN', 'en', 'St. Kitts and Nevis'),
(197, 'PM', 'en', 'St. Pierre and Miquelon'),
(198, 'VC', 'en', 'St. Vincent and the Grenadines'),
(199, 'SD', 'en', 'Sudan'),
(200, 'SR', 'en', 'Suriname'),
(201, 'SJ', 'en', 'Svalbard and Jan Mayen Islands'),
(202, 'SZ', 'en', 'Swaziland'),
(203, 'SE', 'en', 'Sweden'),
(204, 'CH', 'en', 'Switzerland'),
(205, 'SY', 'en', 'Syrian Arab Republic'),
(206, 'TW', 'en', 'Taiwan'),
(207, 'TJ', 'en', 'Tajikistan'),
(208, 'TZ', 'en', 'Tanzania, United Republic of'),
(209, 'TH', 'en', 'Thailand'),
(210, 'TG', 'en', 'Togo'),
(211, 'TK', 'en', 'Tokelau'),
(212, 'TO', 'en', 'Tonga'),
(213, 'TT', 'en', 'Trinidad and Tobago'),
(214, 'TN', 'en', 'Tunisia'),
(215, 'TR', 'en', 'Turkey'),
(216, 'TM', 'en', 'Turkmenistan'),
(217, 'TC', 'en', 'Turks and Caicos Islands'),
(218, 'TV', 'en', 'Tuvalu'),
(219, 'UG', 'en', 'Uganda'),
(220, 'UA', 'en', 'Ukraine'),
(221, 'AE', 'en', 'United Arab Emirates'),
(222, 'GB', 'en', 'United Kingdom (GB)'),
(223, 'US', 'en', 'United States'),
(224, 'VI', 'en', 'United States Virgin Islands'),
(225, 'UY', 'en', 'Uruguay'),
(226, 'UZ', 'en', 'Uzbekistan'),
(227, 'VU', 'en', 'Vanuatu'),
(228, 'VA', 'en', 'Vatican City State'),
(229, 'VE', 'en', 'Venezuela'),
(230, 'VN', 'en', 'Vietnam'),
(231, 'WF', 'en', 'Wallis and Futuna Islands'),
(232, 'EH', 'en', 'Western Sahara'),
(233, 'YE', 'en', 'Yemen'),
(234, 'ZR', 'en', 'Zaire'),
(235, 'ZM', 'en', 'Zambia'),
(236, 'ZW', 'en', 'Zimbabwe'),
(246, 'AD', 'es', 'Andorra'),
(245, 'AS', 'es', 'Samoa Americana'),
(244, 'DZ', 'es', 'Argelia'),
(242, 'AF', 'es', 'Afganistn'),
(243, 'AL', 'es', 'Albania'),
(247, 'AO', 'es', 'Angola'),
(248, 'AI', 'es', 'Anguilla'),
(249, 'AQ', 'es', 'Antrtica'),
(250, 'AG', 'es', 'Antigua y Barbuda'),
(251, 'AR', 'es', 'Argentina'),
(252, 'AM', 'es', 'Armenia'),
(253, 'AW', 'es', 'Aruba'),
(254, 'AU', 'es', 'Australia'),
(255, 'AT', 'es', 'Austria'),
(256, 'AZ', 'es', 'Azerbaijan'),
(257, 'BS', 'es', 'Bahamas'),
(258, 'BH', 'es', 'Bahrein'),
(259, 'BD', 'es', 'Bangladesh'),
(260, 'BB', 'es', 'Barbados'),
(261, 'BY', 'es', 'Bielorrusia'),
(262, 'BE', 'es', 'Blgica'),
(263, 'BZ', 'es', 'Belice'),
(264, 'BJ', 'es', 'Benin'),
(265, 'BM', 'es', 'Bermuda'),
(266, 'BT', 'es', 'Bhutan'),
(267, 'BO', 'es', 'Bolivia'),
(268, 'BA', 'es', 'Bosnia y Herzegovina'),
(269, 'BW', 'es', 'Botswana'),
(270, 'BV', 'es', 'Isla Bouvet'),
(271, 'BR', 'es', 'Brasil'),
(272, 'IO', 'es', 'Territorio Britnico del Ocano ndico'),
(273, 'VG', 'es', 'Islas Vrgenes Britnicas'),
(274, 'BN', 'es', 'Brunei Darussalam'),
(275, 'BG', 'es', 'Bulgaria'),
(276, 'BF', 'es', 'Burkina Faso'),
(277, 'BI', 'es', 'Burundi'),
(278, 'KH', 'es', 'Camboya'),
(279, 'CM', 'es', 'Camern'),
(280, 'CA', 'es', 'Canad'),
(281, 'CV', 'es', 'Cabo Verde'),
(282, 'KY', 'es', 'Islas Caimn'),
(283, 'CF', 'es', 'Repblica Centroafricana'),
(284, 'TD', 'es', 'Chad'),
(285, 'CL', 'es', 'Chile'),
(286, 'CN', 'es', 'China'),
(287, 'CX', 'es', 'Isla de Navidad'),
(288, 'CC', 'es', 'Cocos (Keeling)'),
(289, 'CO', 'es', 'Colombia'),
(290, 'KM', 'es', 'Comoras'),
(291, 'CG', 'es', 'Congo'),
(292, 'CK', 'es', 'Islas Cook'),
(293, 'CR', 'es', 'Costa Rica'),
(294, 'CI', 'es', 'Costa de Marfil'),
(295, 'HR', 'es', 'Croacia'),
(296, 'CU', 'es', 'Cuba'),
(297, 'CY', 'es', 'Chipre'),
(298, 'CZ', 'es', 'Repblica Checa'),
(299, 'DK', 'es', 'Dinamarca'),
(300, 'DJ', 'es', 'Djibouti'),
(301, 'DM', 'es', 'Dominica'),
(302, 'DO', 'es', 'Repblica Dominicana'),
(303, 'TP', 'es', 'Timor del Este'),
(304, 'EC', 'es', 'Ecuador'),
(305, 'EG', 'es', 'Egipto'),
(306, 'SV', 'es', 'El Salvador'),
(307, 'GQ', 'es', 'Guinea Ecuatorial'),
(308, 'ER', 'es', 'Eritrea'),
(309, 'EE', 'es', 'Estonia'),
(310, 'ET', 'es', 'Etiopa'),
(311, 'FK', 'es', 'Islas Malvinas (Falkland)'),
(312, 'FO', 'es', 'Islas Feroe'),
(313, 'FJ', 'es', 'Fiji'),
(314, 'FI', 'es', 'Finlandia'),
(315, 'FR', 'es', 'Francia'),
(316, 'GF', 'es', 'Guiana francs'),
(317, 'PF', 'es', 'Polinesia francs'),
(318, 'TF', 'es', 'Territorios Australes Franceses'),
(319, 'GA', 'es', 'Gabn'),
(320, 'GM', 'es', 'Gambia'),
(321, 'GE', 'es', 'Georgia'),
(322, 'DE', 'es', 'Alemania'),
(323, 'GH', 'es', 'Ghana'),
(324, 'GI', 'es', 'Gibraltar'),
(325, 'GR', 'es', 'Grecia'),
(326, 'GL', 'es', 'Groenlandia'),
(327, 'GD', 'es', 'Granada'),
(328, 'GP', 'es', 'Guadalupe'),
(329, 'GU', 'es', 'Guam'),
(330, 'GT', 'es', 'Guatemala'),
(331, 'GN', 'es', 'Guinea'),
(332, 'GW', 'es', 'Guinea-Bissau'),
(333, 'GY', 'es', 'Guayana'),
(334, 'HT', 'es', 'Hait'),
(335, 'HM', 'es', 'Islas Heard y McDonald'),
(336, 'HN', 'es', 'Honduras'),
(337, 'HK', 'es', 'Hong Kong'),
(338, 'HU', 'es', 'Hungra'),
(339, 'IS', 'es', 'Islandia'),
(340, 'IN', 'es', 'India'),
(341, 'ID', 'es', 'Indonesia'),
(342, 'IQ', 'es', 'Irak'),
(343, 'IE', 'es', 'Irlanda'),
(344, 'IR', 'es', 'Repblica Islmica de Irn'),
(345, 'IL', 'es', 'Israel'),
(346, 'IT', 'es', 'Italia'),
(347, 'JM', 'es', 'Jamaica'),
(348, 'JP', 'es', 'Japn'),
(349, 'JO', 'es', 'Jordania'),
(350, 'KZ', 'es', 'Kazajstn'),
(351, 'KE', 'es', 'Kenia'),
(352, 'KI', 'es', 'Kiribati'),
(353, 'KP', 'es', 'Repblica Popular Democrtica de Corea'),
(354, 'KR', 'es', 'Corea, Repblica de'),
(355, 'KW', 'es', 'Kuwait'),
(356, 'KG', 'es', 'Kirguistn'),
(357, 'LA', 'es', 'Laos'),
(358, 'LV', 'es', 'Letonia'),
(359, 'LB', 'es', 'Lbano'),
(360, 'LS', 'es', 'Lesotho'),
(361, 'LR', 'es', 'Liberia'),
(362, 'LY', 'es', 'Libia'),
(363, 'LI', 'es', 'Liechtenstein'),
(364, 'LT', 'es', 'Lituania'),
(365, 'LU', 'es', 'Luxemburgo'),
(366, 'MO', 'es', 'Macau'),
(367, 'MK', 'es', 'Macedonia'),
(368, 'MG', 'es', 'Madagascar'),
(369, 'MW', 'es', 'Malawi'),
(370, 'MY', 'es', 'Malasia'),
(371, 'MV', 'es', 'Maldivas'),
(372, 'ML', 'es', 'Mal'),
(373, 'MT', 'es', 'Malta'),
(374, 'MH', 'es', 'Islas Marshall'),
(375, 'MQ', 'es', 'Martinica'),
(376, 'MR', 'es', 'Mauritania'),
(377, 'MU', 'es', 'Mauricio'),
(378, 'YT', 'es', 'Mayotte'),
(379, 'MX', 'es', 'Mxico'),
(380, 'FM', 'es', 'Micronesia'),
(381, 'MD', 'es', 'Moldova, Repblica de'),
(382, 'MC', 'es', 'Mnaco'),
(383, 'MN', 'es', 'Mongolia'),
(384, 'MS', 'es', 'Montserrat'),
(385, 'MA', 'es', 'Marruecos'),
(386, 'MZ', 'es', 'Mozambique'),
(387, 'MM', 'es', 'Myanmar'),
(388, 'NA', 'es', 'Namibia'),
(389, 'NR', 'es', 'Nauru'),
(390, 'NP', 'es', 'Nepal'),
(391, 'NL', 'es', 'Pases Bajos'),
(392, 'AN', 'es', 'Antillas Holandesas'),
(393, 'NC', 'es', 'Nueva Caledonia'),
(394, 'NZ', 'es', 'Nueva Zelandia'),
(395, 'NI', 'es', 'Nicaragua'),
(396, 'NE', 'es', 'Nger'),
(397, 'NG', 'es', 'Nigeria'),
(398, 'NU', 'es', 'Niue'),
(399, 'NF', 'es', 'Isla Norfolk'),
(400, 'MP', 'es', 'Islas Marianas del Norte'),
(401, 'NO', 'es', 'Noruega'),
(402, 'OM', 'es', 'Omn'),
(403, 'PK', 'es', 'Pakistn'),
(404, 'PW', 'es', 'Palau'),
(405, 'PA', 'es', 'Panam'),
(406, 'PG', 'es', 'Papa Nueva Guinea'),
(407, 'PY', 'es', 'Paraguay'),
(408, 'PE', 'es', 'Per'),
(409, 'PH', 'es', 'Filipinas'),
(410, 'PN', 'es', 'Pitcairn'),
(411, 'PL', 'es', 'Polonia'),
(412, 'PT', 'es', 'Portugal'),
(413, 'PR', 'es', 'Puerto Rico'),
(414, 'QA', 'es', 'Katar'),
(415, 'RE', 'es', 'Reunin'),
(416, 'RO', 'es', 'Rumania'),
(417, 'RU', 'es', 'Federacin de Rusia'),
(418, 'RW', 'es', 'Ruanda'),
(419, 'LC', 'es', 'Santa Luca'),
(420, 'WS', 'es', 'Samoa'),
(421, 'SM', 'es', 'San Marino'),
(422, 'ST', 'es', 'Sao Tom y Prncipe'),
(423, 'SA', 'es', 'Arabia Saudita'),
(424, 'SN', 'es', 'Senegal'),
(425, 'RS', 'es', 'Repblica de Serbia'),
(426, 'SC', 'es', 'Seychelles'),
(427, 'SL', 'es', 'Sierra Leona'),
(428, 'SG', 'es', 'Singapur'),
(429, 'SK', 'es', 'Eslovaquia'),
(430, 'SI', 'es', 'Eslovenia'),
(431, 'SB', 'es', 'Islas Salomn'),
(432, 'SO', 'es', 'Somalia'),
(433, 'ZA', 'es', 'Sudfrica'),
(434, 'ES', 'es', 'Espaa'),
(435, 'LK', 'es', 'Sri Lanka'),
(436, 'SH', 'es', 'St. Helena'),
(437, 'KN', 'es', 'St. Kitts y Nevis'),
(438, 'PM', 'es', 'St. Pierre y Miquelon'),
(439, 'VC', 'es', 'San Vicente y las Granadinas'),
(440, 'SD', 'es', 'Sudn'),
(441, 'SR', 'es', 'Suriname'),
(442, 'SJ', 'es', 'Islas Svalbard y Jan Mayen'),
(443, 'SZ', 'es', 'Swazilandia'),
(444, 'SE', 'es', 'Suecia'),
(445, 'CH', 'es', 'Suiza'),
(446, 'SY', 'es', 'Repblica rabe Siria'),
(447, 'TW', 'es', 'Taiwan'),
(448, 'TJ', 'es', 'Tayikistn'),
(449, 'TZ', 'es', 'Tanzania, Repblica Unida de'),
(450, 'TH', 'es', 'Tailandia'),
(451, 'TG', 'es', 'Togo'),
(452, 'TK', 'es', 'Tokelau'),
(453, 'TO', 'es', 'Tonga'),
(454, 'TT', 'es', 'Trinidad y Tobago'),
(455, 'TN', 'es', 'Tnez'),
(456, 'TR', 'es', 'Turqua'),
(457, 'TM', 'es', 'Turkmenistn'),
(458, 'TC', 'es', 'Islas Turcas y Caicos'),
(459, 'TV', 'es', 'Tuvalu'),
(460, 'UG', 'es', 'Uganda'),
(461, 'UA', 'es', 'Ucrania'),
(462, 'AE', 'es', 'Emiratos rabes Unidos'),
(463, 'GB', 'es', 'Reino Unido (GB)'),
(464, 'US', 'es', 'Estados Unidos'),
(465, 'VI', 'es', 'Estados Unidos Islas Vrgenes'),
(466, 'UY', 'es', 'Uruguay'),
(467, 'UZ', 'es', 'Uzbekistn'),
(468, 'VU', 'es', 'Vanuatu'),
(469, 'VA', 'es', 'Ciudad del Vaticano'),
(470, 'VE', 'es', 'Venezuela'),
(471, 'VN', 'es', 'Vietnam'),
(472, 'WF', 'es', 'Islas Wallis y Futuna'),
(473, 'EH', 'es', 'Shara Occidental'),
(474, 'YE', 'es', 'Yemen'),
(475, 'ZR', 'es', 'Zaire'),
(476, 'ZM', 'es', 'Zambia'),
(477, 'ZW', 'es', 'Zimbabue'),
(478, 'AF', 'de', 'Afghanistan'),
(479, 'AL', 'de', 'Albanien'),
(480, 'DZ', 'de', 'Algerien'),
(481, 'AS', 'de', 'Amerikanische Samoa'),
(482, 'AD', 'de', 'Andorra'),
(483, 'AO', 'de', 'Angola'),
(484, 'AI', 'de', 'Anguilla'),
(485, 'AQ', 'de', 'Antarktis'),
(486, 'AG', 'de', 'Antigua und Barbuda'),
(487, 'AR', 'de', 'Argentinien'),
(488, 'AM', 'de', 'Armenien'),
(489, 'AW', 'de', 'Aruba'),
(490, 'AU', 'de', 'Australien'),
(491, 'AT', 'de', 'sterreich'),
(492, 'AZ', 'de', 'Aserbaidschan'),
(493, 'BS', 'de', 'Bahamas'),
(494, 'BH', 'de', 'Bahrain'),
(495, 'BD', 'de', 'Bangladesch'),
(496, 'BB', 'de', 'Barbados'),
(497, 'BY', 'de', 'Weirussland'),
(498, 'BE', 'de', 'Belgien'),
(499, 'BZ', 'de', 'Belize'),
(500, 'BJ', 'de', 'Benin'),
(501, 'BM', 'de', 'Bermuda'),
(502, 'BT', 'de', 'Bhutan'),
(503, 'BO', 'de', 'Bolivien'),
(504, 'BA', 'de', 'Bosnien und Herzegowina'),
(505, 'BW', 'de', 'Botswana'),
(506, 'BV', 'de', 'Bouvet-Insel'),
(507, 'BR', 'de', 'Brasilien'),
(508, 'IO', 'de', 'Britisches Territorium im Indischen Ozean'),
(509, 'VG', 'de', 'British Virgin Islands'),
(510, 'BN', 'de', 'Brunei Darussalam'),
(511, 'BG', 'de', 'Bulgarien'),
(512, 'BF', 'de', 'Burkina Faso'),
(513, 'BI', 'de', 'Burundi'),
(514, 'KH', 'de', 'Kambodscha'),
(515, 'CM', 'de', 'Kamerun'),
(516, 'CA', 'de', 'Kanada'),
(517, 'CV', 'de', 'Cape Verde'),
(518, 'KY', 'de', 'Cayman Islands'),
(519, 'CF', 'de', 'Zentralafrikanische Republik'),
(520, 'TD', 'de', 'Chad'),
(521, 'CL', 'de', 'Chile'),
(522, 'CN', 'de', 'China'),
(523, 'CX', 'de', 'Weihnachtsinsel'),
(524, 'CC', 'de', 'Cocos (Keeling) Inseln'),
(525, 'CO', 'de', 'Kolumbien'),
(526, 'KM', 'de', 'Komoren'),
(527, 'CG', 'de', 'Kongo'),
(528, 'CK', 'de', 'Cook Islands'),
(529, 'CR', 'de', 'Costa Rica'),
(530, 'CI', 'de', 'Elfenbeinkste'),
(531, 'HR', 'de', 'Kroatien'),
(532, 'CU', 'de', 'Kuba'),
(533, 'CY', 'de', 'Zypern'),
(534, 'CZ', 'de', 'Tschechische Republik'),
(535, 'DK', 'de', 'Dnemark'),
(536, 'DJ', 'de', 'Djibouti'),
(537, 'DM', 'de', 'Dominica'),
(538, 'DO', 'de', 'Dominikanische Republik'),
(539, 'TP', 'de', 'Osttimor'),
(540, 'EC', 'de', 'Ecuador'),
(541, 'EG', 'de', 'gypten'),
(542, 'SV', 'de', 'El Salvador'),
(543, 'GQ', 'de', 'quatorial-Guinea'),
(544, 'ER', 'de', 'Eritrea'),
(545, 'EE', 'de', 'Estland'),
(546, 'ET', 'de', 'thiopien'),
(547, 'FK', 'de', 'Falklandinseln (Malvinas)'),
(548, 'FO', 'de', 'Frer-Inseln'),
(549, 'FJ', 'de', 'Fidschi'),
(550, 'FI', 'de', 'Finnland'),
(551, 'FR', 'de', 'Frankreich'),
(552, 'GF', 'de', 'Franzsisch-Guayana'),
(553, 'PF', 'de', 'Franzsisch-Polynesien'),
(554, 'TF', 'de', 'Franzsisch Southern Territories'),
(555, 'GA', 'de', 'Gabun'),
(556, 'GM', 'de', 'Gambia'),
(557, 'GE', 'de', 'Georgien'),
(558, 'DE', 'de', 'Deutschland'),
(559, 'GH', 'de', 'Ghana'),
(560, 'GI', 'de', 'Gibraltar'),
(561, 'GR', 'de', 'Griechenland'),
(562, 'GL', 'de', 'Grnland'),
(563, 'GD', 'de', 'Grenada'),
(564, 'GP', 'de', 'Guadeloupe'),
(565, 'GU', 'de', 'Guam'),
(566, 'GT', 'de', 'Guatemala'),
(567, 'GN', 'de', 'Guinea'),
(568, 'GW', 'de', 'Guinea-Bissau'),
(569, 'GY', 'de', 'Guyana'),
(570, 'HT', 'de', 'Haiti'),
(571, 'HM', 'de', 'Heard-und McDonald-Inseln'),
(572, 'HN', 'de', 'Honduras'),
(573, 'HK', 'de', 'Hong Kong'),
(574, 'HU', 'de', 'Ungarn'),
(575, 'IS', 'de', 'Island'),
(576, 'IN', 'de', 'Indien'),
(577, 'ID', 'de', 'Indonesien'),
(578, 'IQ', 'de', 'Irak'),
(579, 'IE', 'de', 'Irland'),
(580, 'IR', 'de', 'Islamische Republik Iran'),
(581, 'IL', 'de', 'Israel'),
(582, 'IT', 'de', 'Italien'),
(583, 'JM', 'de', 'Jamaica'),
(584, 'JP', 'de', 'Japan'),
(585, 'JO', 'de', 'Jordan'),
(586, 'KZ', 'de', 'Kasachstan'),
(587, 'KE', 'de', 'Kenia'),
(588, 'KI', 'de', 'Kiribati'),
(589, 'KP', 'de', 'Demokratische Volksrepublik Korea'),
(590, 'KR', 'de', 'Korea, Republik'),
(591, 'KW', 'de', 'Kuwait'),
(592, 'KG', 'de', 'Kirgisistan'),
(593, 'LA', 'de', 'Laos'),
(594, 'LV', 'de', 'Lettland'),
(595, 'LB', 'de', 'Libanon'),
(596, 'LS', 'de', 'Lesotho'),
(597, 'LR', 'de', 'Liberia'),
(598, 'LY', 'de', 'Libyen'),
(599, 'LI', 'de', 'Liechtenstein'),
(600, 'LT', 'de', 'Litauen'),
(601, 'LU', 'de', 'Luxemburg'),
(602, 'MO', 'de', 'Macau'),
(603, 'MK', 'de', 'Mazedonien'),
(604, 'MG', 'de', 'Madagaskar'),
(605, 'MW', 'de', 'Malawi'),
(606, 'MY', 'de', 'Malaysia'),
(607, 'MV', 'de', 'Malediven'),
(608, 'ML', 'de', 'Mali'),
(609, 'MT', 'de', 'Malta'),
(610, 'MH', 'de', 'Marshall Inseln'),
(611, 'MQ', 'de', 'Martinique'),
(612, 'MR', 'de', 'Mauretanien'),
(613, 'MU', 'de', 'Mauritius'),
(614, 'YT', 'de', 'Mayotte'),
(615, 'MX', 'de', 'Mexiko'),
(616, 'FM', 'de', 'Mikronesien'),
(617, 'MD', 'de', 'Moldova, Republik'),
(618, 'MC', 'de', 'Monaco'),
(619, 'MN', 'de', 'Mongolei'),
(620, 'MS', 'de', 'Montserrat'),
(621, 'MA', 'de', 'Marokko'),
(622, 'MZ', 'de', 'Mosambik'),
(623, 'MM', 'de', 'Myanmar'),
(624, 'NA', 'de', 'Namibia'),
(625, 'NR', 'de', 'Nauru'),
(626, 'NP', 'de', 'Nepal'),
(627, 'NL', 'de', 'Niederlande'),
(628, 'AN', 'de', 'Niederlndische Antillen'),
(629, 'NC', 'de', 'Neukaledonien'),
(630, 'NZ', 'de', 'Neuseeland'),
(631, 'NI', 'de', 'Nicaragua'),
(632, 'NE', 'de', 'Niger'),
(633, 'NG', 'de', 'Nigeria'),
(634, 'NU', 'de', 'Niue'),
(635, 'NF', 'de', 'Norfolk-Insel'),
(636, 'MP', 'de', 'Northern Mariana Islands'),
(637, 'NO', 'de', 'Norwegen'),
(638, 'OM', 'de', 'Oman'),
(639, 'PK', 'de', 'Pakistan'),
(640, 'PW', 'de', 'Palau'),
(641, 'PA', 'de', 'Panama'),
(642, 'PG', 'de', 'Papua-Neuguinea'),
(643, 'PY', 'de', 'Paraguay'),
(644, 'PE', 'de', 'Peru'),
(645, 'PH', 'de', 'Philippinen'),
(646, 'PN', 'de', 'Pitcairn'),
(647, 'PL', 'de', 'Polen'),
(648, 'PT', 'de', 'Portugal'),
(649, 'PR', 'de', 'Puerto Rico'),
(650, 'QA', 'de', 'Qatar'),
(651, 'RE', 'de', 'Reunion'),
(652, 'RO', 'de', 'Rumnien'),
(653, 'RU', 'de', 'Russische Fderation'),
(654, 'RW', 'de', 'Ruanda'),
(655, 'LC', 'de', 'St. Lucia'),
(656, 'WS', 'de', 'Samoa'),
(657, 'SM', 'de', 'San Marino'),
(658, 'ST', 'de', 'Sao Tome und Principe'),
(659, 'SA', 'de', 'Saudi-Arabien'),
(660, 'SN', 'de', 'Senegal'),
(661, 'RS', 'de', 'Republik Serbien'),
(662, 'SC', 'de', 'Seychellen'),
(663, 'SL', 'de', 'Sierra Leone'),
(664, 'SG', 'de', 'Singapur'),
(665, 'SK', 'de', 'Slowakei'),
(666, 'SI', 'de', 'Slowenien'),
(667, 'SB', 'de', 'Solomon Islands'),
(668, 'SO', 'de', 'Somalia'),
(669, 'ZA', 'de', 'Sdafrika'),
(670, 'ES', 'de', 'Spanien'),
(671, 'de', 'de', 'Deutschland'),
(672, 'LK', 'de', 'Sri Lanka'),
(673, 'SH', 'de', 'St. Helena'),
(674, 'KN', 'de', 'St. Kitts und Nevis'),
(675, 'PM', 'de', 'St. Pierre und Miquelon'),
(676, 'VC', 'de', 'St. Vincent und die Grenadinen'),
(677, 'SD', 'de', 'Sudan'),
(678, 'SR', 'de', 'Suriname'),
(679, 'SJ', 'de', 'Spitzbergen und Jan Mayen Inseln'),
(680, 'SZ', 'de', 'Swaziland'),
(681, 'SE', 'de', 'Schweden'),
(682, 'CH', 'de', 'Schweiz'),
(683, 'SY', 'de', 'Arabischen Republik Syrien'),
(684, 'TW', 'de', 'Taiwan'),
(685, 'TJ', 'de', 'Tadschikistan'),
(686, 'TZ', 'de', 'Tansania, Vereinigte Republik'),
(687, 'TH', 'de', 'Thailand'),
(688, 'TG', 'de', 'Togo'),
(689, 'TK', 'de', 'Tokelau'),
(690, 'TO', 'de', 'Tonga'),
(691, 'TT', 'de', 'Trinidad und Tobago'),
(692, 'TN', 'de', 'Tunesien'),
(693, 'TR', 'de', 'Trkei'),
(694, 'TM', 'de', 'Turkmenistan'),
(695, 'TC', 'de', 'Turks-und Caicosinseln'),
(696, 'TV', 'de', 'Tuvalu'),
(697, 'UG', 'de', 'Uganda'),
(698, 'UA', 'de', 'Ukraine'),
(699, 'AE', 'de', 'Vereinigte Arabische Emirate'),
(700, 'GB', 'de', 'Grobritannien (GB)'),
(701, 'US', 'de', 'Vereinigte Staaten von Amerika'),
(702, 'VI', 'de', 'United States Virgin Islands'),
(703, 'UY', 'de', 'Uruguay'),
(704, 'UZ', 'de', 'Usbekistan'),
(705, 'VU', 'de', 'Vanuatu'),
(706, 'VA', 'de', 'Vatikanstadt'),
(707, 'VE', 'de', 'Venezuela'),
(708, 'VN', 'de', 'Vietnam'),
(709, 'WF', 'de', 'Wallis und Futuna'),
(710, 'EH', 'de', 'Westsahara'),
(711, 'YE', 'de', 'Jemen'),
(712, 'ZR', 'de', 'Zaire'),
(713, 'ZM', 'de', 'Sambia'),
(714, 'ZW', 'de', 'Simbabwe');
