#include "Module.h"

#include "Abstracts.h"
#include "Create.h"
#include "Command_template.h"
#include "Crystal_builder_impl.h"
#include "Panel_sequence_editor.h"
#include "Panel_sequence.h"
#include "Panel_build_crystal.h"
#include "Panel_charges.h"
#include "Project.h"


namespace MM
{

class Module_build : public Module
{
    static Module_build     singleton_;
                            Module_build() ;
    void                    init ();

    void                    edit_sequence ();
    void                    build_crystal ();
    void                    edit_charges  ();
};
Module_build  Module_build::singleton_;


Module_build::Module_build () : Module ("Build") { }

void  Module_build::
init ()
{
    insert_menu_separator ("&Build");


    adopt_command (create_command (*this, &Module_build::edit_sequence))
        .set_icon        ("Build", "sequence.png")
        .set_tool_tip    ("Build chain")
        .set_menu        ("&Build", "&Chain");

    adopt_command (create_command (*this, &Module_build::build_crystal))
        .set_icon        ("Build", "crystal.png")
        .set_tool_tip    ("Build crystal")
        .set_menu        ("&Build", "C&rystal");


    Prototype_repository::singleton()
        .adopt ((Crystal_builder*) new Crystal_builder_impl (Prototype()));     //fix

    adopt_command (create_command (*this, &Module_build::edit_charges))
        .set_menu        ("&Build", "&Charges");
}

void Module_build::
edit_sequence ()
{
    //Form_sequence_editor::pop_up ();

    Panel_sequence       ::singleton()->popup ();
    Panel_sequence_editor::singleton()->popup ();
}

void Module_build::
build_crystal ()
{
    Panel_build_crystal::singleton()->popup ();
}

void Module_build::
edit_charges ()
{
    Panel_charges::singleton()->popup ();
}

}//MM
