#ifndef PANEL_BUILD_CRYSTAL
#define PANEL_BUILD_CRYSTAL

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef UI_PANEL_BUILD_CRYSTAL_H
#include "ui_Panel_build_crystal.h"
#endif

#ifndef MODEL_SINGLETON_VIEW_H
#include "Model_singleton_view.h"
#endif

#include <QTimer>

class QValidator;

namespace MM
{
class Crystal_builder;

class Panel_build_crystal
:
    public Panel,
    public Ui_Panel_build_crystal,
    public Model_singleton_view,
    public Dynamic_singleton <Panel_build_crystal>
{
    Q_OBJECT

    using Panel::check;
    using Panel::require;
    //QTimer  timer_;

    bool                silent_flag_;

    void                select   (bool on);
    Crystal_builder &   builder ();
    Model &             model ();

public:    
    Panel_build_crystal ();

    void            showEvent (QShowEvent * event);

public slots:
    void            renew_current_model (Model &);
    void            renew (Model_event::Hint hint 
                        = Model_event::Structure_changed);

    void            update_panel ();

    void            from_fractional_to_cartesian();
    void            set_FCC_Type (const QString &);
    void            set_use_PBC (int);

    void            accept_lattice_paramiters (const QString &);
    void            accept_lattice_paramiters ();
    void            accept_lattice_vectors    (const QString &);
    void            accept_number_of_copies   ();

    void            set_close_packed (int)    {update_panel ();}
    void            set_full_control (int)    {update_panel ();}

    void            apply  ();
    void            select ();

private:
    void            update_controls           ();
    void            update_lattice_paramiters ();
    void            update_lattice_vectors    ();
    void            update_copies             ();
};

}//MM

#endif//PANEL_BUILD_CRYSTAL
