#include "Module.h"

#include "Peep.h"

#include "Panel_dynamics.h"
#include "Panel_boundary_conditions.h"
//#include "Panel_nano.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "Common_interactions.h"
#include "Panel_solvation.h"

namespace MM
{

class Module_dynamics : public Module
{
    static Module_dynamics      singleton_;
                            Module_dynamics() ;
    void                    init ();
  //  void                    free_nano  ();

    void                    implicit_water ();
};
Module_dynamics  Module_dynamics::singleton_;


Module_dynamics::Module_dynamics () : Module ("Dynamics") { }

void  Module_dynamics::
init ()
{
    struct Dynamics : public Command
        {void execute()  {Panel_dynamics::singleton()->popup ();}};

    struct Delete_restraints : public Command
    {
        void execute()  //fix
        {
            Model & model = Project::singleton().current_model();
            model.kit ().clear_interactions();
            //model.kit ().adopt_interaction(
            //    Common_interactions::create (
            //        model, model, Force_field::singleton()));
        }
    };

    //insert_menu_separator ("&File");

    adopt_command (new Dynamics)
        .set_menu        ("&Compute", "&Dynamics")
        .set_tool_tip    ("Molecular Dynamics")
        //.set_accelerator ("Ctrl+D")
        .set_icon        ("Compute", "dynamics.png");


    adopt_command (new Delete_restraints)
        .set_menu        ("&Edit", "&Delete restraints")
        ;

    //insert_menu_separator ("&Edit");
/*
    adopt_command (create_command (*this, &Module_dynamics::free_nano))
        .set_menu        ("&Build", "&Nano")
        .set_tool_tip    ("Nano structures")
        .set_icon        ("Build", "NanoTube.png");//*/


    //insert_menu_separator ("&Build");


    adopt_command (create_command (*this, &Module_dynamics::implicit_water))
        .set_menu        ("Settings", "Implicit water");

}
/*
void Module_dynamics::
free_nano ()
{
    Panel_nano::singleton()->popup ();
}
//*/

void Module_dynamics::
implicit_water ()
{
    //Panel_force_field::singleton ()->popup();
    Panel_solvation::singleton ()->popup();
}

}//MM
