#ifndef PANEL_BOUNDARY_CONDITIONS_H
#define PANEL_BOUNDARY_CONDITIONS_H

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef MODEL_SINGLETON_VIEW_H
#include "Model_singleton_view.h"
#endif

#ifndef UI_PANEL_BOUNDARY_CONDITIONS_H
#include "ui_Panel_boundary_conditions.h"
#endif


namespace MM
{

class Panel_boundary_conditions
:
    public Panel,
    public Ui_Panel_boundary_conditions,
    public Model_singleton_view,
    public Dynamic_singleton <Panel_boundary_conditions>
{
    Q_OBJECT

public:    
    Panel_boundary_conditions ();

    void            renew_current_model (Model &);
    void            renew ();
    void            renew (Model_event::Hint);

public slots:
    void            set_dielectric_permittivity (double);
    void            set_cutoff (double);
    void            set_box_x  ();
    void            set_density();
    void            set_boundary_conditions (int index);

protected:
    virtual void    turn (bool on) {if(on) renew ();}
};

}//MM

#endif //PANEL_BOUNDARY_CONDITIONS_H
