#ifndef PANEL_DYNAMICS_H
#define PANEL_DYNAMICS_H

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef UI_PANEL_DYNAMICS_H
#include "ui_Panel_dynamics.h"
#endif

#ifndef MODEL_SINGLETON_VIEW_H
#include "Model_singleton_view.h"
#endif


namespace MM
{
class Main_window;

class Panel_dynamics
:
    public Panel,
    public Ui_Panel_dynamics,
    public Model_singleton_view,
    public Dynamic_singleton <Panel_dynamics>
{
    Q_OBJECT

    Main_window *   player_;

public:    
    Panel_dynamics ();

public slots:
    void                set_tool        (const QString & text);
    void                set_integrator  (const QString & text);
    void                set_inner_steps   (int);
    void                set_inner_steps_2 (int);
    void                set_inner_steps_3 (int);
    void                set_R             (double);
    void                set_R_2           (double);
    //void                set_R_3           (int);
    void                barostat        (int on);
    void                set_pressure    (double);
    void                set_barostat_Tau(double);

    void                thermostat      (int on);
    void                show_thermostat (const QString & type);
    void                set_temperature (double);
    void                set_steps       (double);
    void                set_response_constant(double);    
    void                check_full_control (int);

    void                integrator_full_control (bool);
    void                barostat_full_control   (bool);
    void                thermostat_full_control (bool);
    void                full_control            (bool);
    
    void                turn_min_mass   (int);
    void                set_min_mass    (double);

    void                renew_current_model (Model &);
    void                renew (Model_event::Hint hint 
                             = Model_event::Structure_changed);

    //void                run (bool);
    void                run   ();
    //void            check ();
    void                tune  ();
    void                start ();
    void                stop  ();

protected:
    void                set_stop_state ();
    void                set_run_state  ();

    void                turn (bool on);
    void                closeEvent (QCloseEvent * event);

};

}//MM

#endif //PANEL_DYNAMICS_H
