#ifndef COLLECT_TEMPERATURE_FROM_MDYNAMIX_H
#define COLLECT_TEMPERATURE_FROM_MDYNAMIX_H

#ifndef COLLECT_SCALAR_H
#include "Collect_scalar.h"
#endif

#include "Collect_scalar_to_file.h" //fix  to .cpp

namespace MM
{

class Collect_temperature_from_mDynaMix : public Collect_scalar
{
    double      current_value_;

public:
    explicit Collect_temperature_from_mDynaMix (Atom_group & atom_group)
    :
        Collect_scalar (atom_group, "Simulator"),
        current_value_ (0.)
    {
        //adopt_file_presentation
        //    (new Collect_scalar_to_file ("_md_temperature.xls"));
        new_graph_presentation ("temperature");
    }

//    MD_monitor * clone (Atom_group & atom_group, Text const & args) const
    Monitor * clone (Atom_group & atom_group, Text const &, Text) const
    {
        return new Collect_temperature_from_mDynaMix (atom_group);
    }

    Text         title      () const {return "Temperature";}
    Text         class_name () const {return "Collect_temperature_from_mDynaMix";}

    double       extract_current_value ()       {return current_value_;}
    void         set_current_value (double v)   {current_value_ = v;}
};

}//MM

#endif //COLLECT_TEMPERATURE_FROM_MDYNAMIX_H
