#ifndef M_DYNAMIX_Q4PROCESS_H
#define M_DYNAMIX_Q4PROCESS_H

#ifndef M_DYNAMIX_PROCESS_H
#include "M_DynaMix_process.h"
#endif

//#ifndef OWN_H
//#include "Own.h"
//#endif

//#ifndef FILE_TEXT_OUTPUT_H
//#include "File_text_output.h"
//#endif

#include <QProcess>
#include <QObject>
#include <QFile>

namespace MM
{

class M_DynaMix_Q4Process : public QObject, public M_DynaMix_process
{
    Q_OBJECT

    enum {none, read_coords}            state_;

    QProcess *                          process_;
    //Own <QProcess>                      janitor_;
    Text                                comment_;
    Atom_group *                        ordered_atoms_;
    //Own <File_text_output>              output_;
    QFile                               output_;
    int                                 current_atom_number_;

public:
    explicit M_DynaMix_Q4Process (Interface_for_M_DynaMix_process & simulator);
    void    start (Atom_group * ordered_atoms);
    //void    stop  ();

    bool                is_running () const 
    {
        return process_->state() != QProcess::NotRunning;
    }

protected slots:
    void    started ();
    void    finished(int, QProcess::ExitStatus exitStatus);
    void    read();
};

}//MM

#endif //M_DYNAMIX_Q4PROCESS_H
