#ifndef M_DYNAMIX_MOL_FILE_H
#define M_DYNAMIX_MOL_FILE_H

#include <iosfwd>
#include <string>//fix to text

#ifndef MODEL_FILE_H
#include "Model_file.h"
#endif

namespace MM
{
class Atom_group;
class Bond_group;
class Prototype;

//fix remove
Text & global_sigma_rule   ();
Text & global_epsilon_rule ();

class M_DynaMix_mol_file : public Model_file
{
    static M_DynaMix_mol_file   prototype_;

public:
    explicit            M_DynaMix_mol_file ();
    explicit            M_DynaMix_mol_file (Prototype const &);
    explicit            M_DynaMix_mol_file (Model & model);
    virtual Model_file *clone (Model & model) const;

    virtual bool        support_input  () const {return true;}
    virtual bool        support_output () const {return true;}
    virtual bool        support_bonds     () const {return false;}
    virtual bool        support_molecules () const {return false;}

    virtual Text const& type_name() const {static Text t("m.DynaMix mmol"); return t;}
    virtual void        save (bool to_comment = false);
    virtual void        save (const Atom_group & atoms, const Bond_group & bonds);
    virtual void        check_file_name();
    virtual void        add (Text const & file_name);
    
protected:
    bool                next_line (std::ifstream & in, std::string & line);
};

}//MM

#endif //M_DYNAMIX_MOL_FILE_H
