#ifndef M_DYNAMIX_SMOL_FILE_H
#define M_DYNAMIX_SMOL_FILE_H

#ifndef MODEL_FILE_H
#include "Model_file.h"
#endif

#include <iosfwd>
#include <string>//fix to text

namespace MM
{

class M_DynaMix_smol_file : public Model_file
{
    static M_DynaMix_smol_file  prototype_;

public:
    explicit            M_DynaMix_smol_file ();
    explicit            M_DynaMix_smol_file (Prototype const &);
    explicit            M_DynaMix_smol_file (Model & model);
    virtual Model_file *clone (Model & model) const;

    virtual bool        support_input  () const {return false;}
    virtual bool        support_output () const {return true;}
    virtual bool        support_bonds     () const {return true;}
    virtual bool        support_molecules () const {return false;}

    virtual Text const& type_name () const {static Text t("m.DynaMix smol"); return t;}
    virtual void        save            (bool to_comment = false);
    virtual void        check_file_name ();
    virtual void        add             (Text const & file_name);
    
protected:
    bool            next_line (std::ifstream & in, std::string & line);
};

}//MM

#endif //M_DYNAMIX_SMOL_FILE_H
