#include "Module.h"

#include "Panel_MDynaMix.h"
#include "Panel_dynamics.h"
#include "Command_template.h"

namespace MM
{

class Module_MDynaMix : public Module
{
    static Module_MDynaMix  singleton_;
                            Module_MDynaMix() ;
    void                    init ();

    void                    show_panel ();
};
Module_MDynaMix  Module_MDynaMix::singleton_;


Module_MDynaMix::Module_MDynaMix () : Module ("MDynaMix") { }

void  Module_MDynaMix::
init ()
{
    adopt_command (create_command (*this, &Module_MDynaMix::show_panel))
        //.set_icon       ("Compute", "GAMESS.png")
        .set_tool_tip   ("Shell for MDynaMix molecular dynamics program.")
        .set_menu       ("&Tools", "M&DynaMix");
}

void  Module_MDynaMix::
show_panel ()
{
    Panel_MDynaMix::singleton()->popup ();

    Panel_dynamics::singleton()->popup ();
    Panel_dynamics::singleton()->Tool->setCurrentIndex 
        (Panel_dynamics::singleton()->Tool->findText ("MDynaMix"));
}

}//MM
