#ifndef PANEL_MDYNAMIX_H
#define PANEL_MDYNAMIX_H

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef UI_PANEL_MDYNAMIX_H
#include "ui_Panel_MDynaMix.h"
#endif

#ifndef M_DYNAMIX_INPUT_H
#include "M_DynaMix_input.h"
#endif

#include <QTimer>

namespace MM
{

class Panel_MDynaMix
:
    public Panel,
    public Ui_Panel_MDynaMix,
    public Dynamic_singleton <Panel_MDynaMix>
{
    Q_OBJECT

    QTimer  ewald_timer_;

public:    
    Panel_MDynaMix ();

    void    prepare_input (Text const & filename, 
                           M_DynaMix_input const & input);

public slots:
    void    auto_ewald (bool);
    void    calc_auto_ewald ();

private:
    const char * is_checked (QAbstractButton *b)
    {
        if (b->isChecked()) return "yes";
        else                return "no";
    }
};

}//MM

#endif //PANEL_MDYNAMIX_H
