#include "Dynamic_configuration.h"

#include "Console_configuration.h"
#include "Consecutive_configuration.h"
#include "Graphic_configuration.h"

#include "Demo_configuration.h"
#include "Test_correctness_configuration.h"
#include "Test_performance_configuration.h"
#include "Test_temporary_configuration.h"
#include "Test_all_configuration.h"

#include "Peep.h"

#include <string>

namespace MM
{

Dynamic_configuration::
Dynamic_configuration (int argc, char * argv[])
{
    // Define main configuration
    for (int i=0;  i<argc;  ++i)
    {
        std::string current(argv[i]);
        
        if      (current == "-cs" || current == "-console")
        {
            configuration_.adopt (new Console_configuration (argc, argv));
            break;
        }
        else if (current == "-ct" || current == "-consecutive")
        {
            configuration_.adopt (new Consecutive_configuration (argc, argv));
            break;
        }
        else if (current == "-g"  || current == "-graphic")
        {
            configuration_.adopt (new Graphic_configuration (argc, argv));
            break;
        }
    }

    if (configuration_.size() == 0)
        configuration_.adopt (new Graphic_configuration (argc, argv));


    // Define additional configurations
    for (int j=0;  j<Configuration::argc();  ++j)
    {
        std::string current (Configuration::argv(j).c_str());
        
        if      (current == "-d"   || current == "-demo")
        {
            configuration_.adopt (new Demo_configuration);
        }
        else if (current == "-tc"  || current == "-test_correctness")
        {
            configuration_.adopt (new Test_correctness_configuration);
            //Peep().execute();
        }
        else if (current == "-tp"  || current == "-test_performance")
        {
            configuration_.adopt (new Test_performance_configuration);
        }
        else if (current == "-tt"  || current == "-test_temporary")
        {
            configuration_.adopt (new Test_temporary_configuration);
        }
        else if (current == "-ta"  || current == "-test_all")
        {
            configuration_.adopt (new Test_all_configuration);
        }
    }
}

}//MM
