#ifndef MAIN_WINDOW_H
#define MAIN_WINDOW_H

#include "Array.h"

#include <QMainWindow>
#include <QMdiArea>
#include <QLabel>
#include <QVBoxLayout>
#include <QToolBar>

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef UI_MAIN_WINDOW_H
#include "ui_Main_window.h"
#endif

#include <QMap>

namespace MM
{

class Main_window : 
    public QMainWindow, 
    public Ui_Main_window, 
    public Dynamic_singleton <Main_window>
{
    Q_OBJECT

public:
    QTabBar     *       tabBar;
    QVBoxLayout *       tabBarLayout;
    
    QMdiArea    *       MDI_panel;
    QVBoxLayout *       MDIboxLayout;

    QLabel      *       label;
    QLabel      *       status;

    bool                player_on_;

    Array <QToolBar *>  tool_bar_;

    QMap<QObject*, int> subWindowID;
    QMap<int, QObject*> tabID;

    friend class Dynamic_singleton <Main_window>;
    Main_window ();

public:
    QWidget *       current_model_window ();

    QMenu *         menu     (QString const& title);
    QToolBar *      tool_bar (QString const& title);
    void            adopt_MDI_window  (QWidget *win, QString const& name);
    void            close_all_windows ();

protected slots:
    void            tab_bar_activated    (int             tab);
    void            sub_window_activated (QMdiSubWindow * win);
    void            remove_tab (QObject * win);
    void            remove_left_panel   ();
    void            remove_right_panel  ();
    void            remove_middle_panel ();
    void            remove_bottom_panel ();


public slots:
    void            min_left_panel   ();
    void            min_right_panel  ();
    void            min_middle_panel ();
    void            min_bottom_panel ();

    void            middle_panel_current_changed (int index);

protected:
    void            showEvent  (QShowEvent  * event);
    //void            paintEvent (QPaintEvent * event);
    void            closeEvent (QCloseEvent * event);

    void            setup_log ();
};

}//MM

#endif FORM_MAIN_WINDOW_H
