#include "Main_window_user.h"

#include "Main_window.h"
#include "Path.h"
#include "string_replace.h"
#include "Dialog_choose.h"
#include "Timer.h"

#include <QLabel>
//#include <QFont>
#include <QIcon>
#include <QTabWidget>
#include <QTime>
#include <QString>
#include <QMessageBox>

namespace MM
{
    bool clock_performed_ = false;
}

namespace MM
{

void Main_window_user::
status (Text const & message)
{
    Main_window::singleton()->status->setText (message);
    Main_window::singleton()->status->repaint ();
}

bool  Main_window_user::clock_performed ()
{
    return clock_performed_;
}

void Main_window_user::
clock ()
{
    //return;

    clock_performed_ = true;

    try
    {
        static int count = 0;
        static Timer timer;
        
        //if (timer.elapsed() < 0.04)
        //if (timer.elapsed() < 0.08)
        if (timer.elapsed() < 0.3)
        {
            clock_performed_ = false;
            return;
        }

        timer.restart();

        char symbol = ' ';
        switch (++count%5)
        {
        case 1: symbol = '.'; break;
        case 2: symbol = ':';  break;
        case 3: symbol = '.';  break;
        }

        QString message = Main_window::singleton()->status->text ();
        int size = message.size();

        if (size > 1 &&
            message[size-2] == ' ' && (
            message[size-1] == ' '  || 
            message[size-1] == '.' || 
            //message[size-1] == '|'  || 
            message[size-1] == ':' 
            ))
            message[size-1] = symbol;
        else
        {
            message += ' ';
            message += symbol;
        }

        Main_window::singleton()->status->setText (message);
        Main_window::singleton()->status->repaint ();
    }
    catch(...)
    {
        to_user().error("status->repaint in Main_window_user::clock()");
    }

    try
    {
        qApp->processEvents(QEventLoop::ExcludeSocketNotifiers);
    }
    catch(...)
    {
        to_user().error("qApp->processEvents in Main_window_user::clock()");
    }
    clock_performed_ = false;
}

void Main_window_user::
info (Text const & message)
{
    Text text;
    QTabWidget *    tabWidget = Main_window::singleton()->tabWidget_middle;
    QTextBrowser *  info      = Main_window::singleton()->info;
    int info_index    = tabWidget->indexOf(Main_window::singleton()->tab_Info);
    int current_index = tabWidget->currentIndex ();

    if (info_index != current_index && 
        tabWidget->tabIcon (info_index).isNull())
    {
        QIcon icon;
        icon.addFile((Path::icon() + "!.png").c_str());
        tabWidget->setTabIcon (info_index, icon);

        text =  "<font color=#eeeeee>"
                "____________________________________________________"
                "</font><br><br>";
    }


    QString time = QTime::currentTime ().toString();

    using namespace std;
    string s = message.c_str();
    string_replace (s, "\n", " <br> ");

    text += "<font color=#888888>";
    text += time;
    text += "</font> <font color=#316663>";
    text += s.c_str();
    text += "</font><br>";

    info->moveCursor (QTextCursor::End);
    info->insertHtml (text);
    info->moveCursor (QTextCursor::End);
    info->repaint ();
}

void Main_window_user::
warning (Text const & message)
{
    Text text;
    QTabWidget * tabWidget = Main_window::singleton()->tabWidget_middle;
    QTextBrowser * warn    = Main_window::singleton()->warn;
    int warn_index    = tabWidget->indexOf(Main_window::singleton()->tab_Warn);
    int current_index = tabWidget->currentIndex ();

    if (warn_index != current_index && 
        tabWidget->tabIcon (warn_index).isNull())
    {
        QIcon icon;
        icon.addFile((Path::icon() + "!.png").c_str());
        tabWidget->setTabIcon (warn_index, icon);

        text =  "<font color=#eeeeee>"
                "____________________________________________________"
                "</font><br><br>";
    }

    QString time = QTime::currentTime ().toString();

    using namespace std;
    string s = message.c_str();
    string_replace (s, "\n", " <br> ");

    text += "<font color=#888888>";
    text += time;
    text += "</font> <font color=#316663>";
    text += s.c_str();
    text += "</font><br>";

    warn->moveCursor (QTextCursor::End);
    warn->insertHtml (text);
    warn->moveCursor (QTextCursor::End);
    warn->repaint ();
}

void Main_window_user::
error (Text const & message)
{
    Text text;
    QTabWidget * tabWidget = Main_window::singleton()->tabWidget_middle;
    QTextBrowser * warn    = Main_window::singleton()->warn;
    int warn_index    = tabWidget->indexOf(Main_window::singleton()->tab_Warn);
    int current_index = tabWidget->currentIndex ();

    if (warn_index != current_index && 
        tabWidget->tabIcon (warn_index).isNull())
    {
        QIcon icon;
        icon.addFile((Path::icon() + "!.png").c_str());
        tabWidget->setTabIcon (warn_index, icon);

        text =  "<font color=#eeeeee>"
                "____________________________________________________"
                "</font><br><br>";
    }

    QString time = QTime::currentTime ().toString();

    using namespace std;
    string s = message.c_str();
    string_replace (s, "\n", " <br> ");

    text += "<font color=#888888>";
    text += time;
    text += "</font> <font color=\"#ac7620\"><u>";
    text += s.c_str();
    text += "</u>";
    text += "</font><br>";

    warn->moveCursor (QTextCursor::End);
    warn->insertHtml (text);
    warn->moveCursor (QTextCursor::End);
    warn->repaint ();
}

void Main_window_user::
fatal_error (const Text & message)
{
    QMessageBox::critical (Main_window::singleton() , "Error", message);
}

bool Main_window_user::
question (const Text & message)
{
    QMessageBox::StandardButton result = QMessageBox::
        question (Main_window::singleton(), "Question", message, 
            QMessageBox::Yes | QMessageBox::No, QMessageBox::Yes);

    if (result == QMessageBox::Yes)
        return true;
    return false;
}

bool Main_window_user::
choose (Text const& question, Array <Text> const& list, Text & result)
{
    Dialog_choose choose (question, list, Main_window::singleton());
    
    choose.exec();

    if (choose.result () == QDialog::Accepted)
    {
        result = choose.text ();
        return true;
    }
    return false;
}

bool Main_window_user::
choose (Text const& question, Array <Text> const& list, int & n)
{
    Dialog_choose choose (question, list, Main_window::singleton());
    
    choose.exec();

    if (choose.result () == QDialog::Accepted)
    {
        n = choose.n ();
        return true;
    }
    return false;
}

}//MM
