#ifndef MODEL_RM_WIDGET_H
#define MODEL_RM_WIDGET_H

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef MODEL_H
#include "Model.h"
#endif

#ifndef OPENRMWIDGET_H
#include "OpenRMWidget.h"
#endif

#include <rm/rm.h>
extern "C"
{
struct RMpick;
struct RMvertex3D;
}

namespace MM
{
class Angle_unit;

class Model_RM_widget : public OpenRMWidget
{
    Q_OBJECT

    Model &                 model_;

    RMpick *                pick_;
    RMpick *                select_;
    RMvertex3D              selection_movement_;
    
    //QPoint                  last_position_;

    //int                     idle_timer_id_;
public:

    // return false to continue
    struct Mouse_handler 
    {
        virtual     ~Mouse_handler () {}
        virtual bool execute (QMouseEvent * event, Model_RM_widget *) =0;
    };

    static Mouse_handler *  press_;         
    static Mouse_handler *  release_;         
    static Mouse_handler *  double_click_;         
    static Mouse_handler *  move_;         

    void   movement (QMouseEvent * event, int dX, int dY, 
                     double * x, double * y, double * z,
                     RMvertex3D * eye, RMvertex3D * up, RMvertex3D * rigth,
                     RMvertex3D * at);

    explicit Model_RM_widget (Model & model, QWidget *parent);
    ~Model_RM_widget();

    Model &         model ()    {return model_;}

public slots:
    //void            fit_center    ();
    void            fit_to_screen ();
    //void            flush_camera  ();
    //void            demo_rotation (int steps);
    void            pick (int x, int y);

    void            right_X_view (Angle_unit const &);
    void            left_X_view  (Angle_unit const &);
    void            right_Y_view (Angle_unit const &);
    void            left_Y_view  (Angle_unit const &);
    void            right_Z_view (Angle_unit const &);
    void            left_Z_view  (Angle_unit const &);

protected:
    virtual void    set_level_of_details (int lod);
    
    void            keyPressEvent           (QKeyEvent   * event);
    void            mousePressEvent         (QMouseEvent * event);
    void            mouseReleaseEvent       (QMouseEvent * event);
    void            mouseDoubleClickEvent   (QMouseEvent * event);
    void            mouseMoveEvent          (QMouseEvent * event);
    void            paintGL ();

    void            get_dimensions (double &center_x,
                                    double &center_y,
                                    double &center_z,
                                    double &scale);

    //void            fit (double & center_x,
    //                     double & center_y,
    //                     double & center_z,
    //                     double & scale);
     
     //bool            invariant () const;
};

}//MM

#endif //MODEL_RM_WIDGET_H
