#include "Model_RM_window.h"

//#include "Peep.h"
#include <QCloseEvent>


#include "Model.h"
#include "Model_kit.h"
#include "Main_window.h"
#include "Atom.h"
#include "Atom_kit.h"
#include "Project.h"
#include "Model_RM_widget.h"

#include <math.h>

namespace MM
{

Model_RM_window::
Model_RM_window (Model & model)
:
    model_      (model),
    first_show_ (true),
    RM_widget_1_(0),
    RM_widget_2_(0)
{
    setupUi (this); 

    RM_widget_1_ = new Model_RM_widget (model, frame_1);
    RM_widget_2_ = new Model_RM_widget (model, frame_2);

    QHBoxLayout *boxLayout_1 = new QHBoxLayout (frame_1);
    boxLayout_1->setContentsMargins (0, 0, 0, 0);
    boxLayout_1->addWidget (RM_widget_1_);
    //RM_widget_1_->set_model_view (this);

    QHBoxLayout *boxLayout_2 = new QHBoxLayout (frame_2);
    boxLayout_2->setContentsMargins (0, 0, 0, 0);
    boxLayout_2->addWidget (RM_widget_2_);
    //RM_widget_2_->set_model_view (this);

    //model.atom_prototype().kit().add_visual 
    //    (new OpenRM_atom (RM_widget_1_->object_node(), RM_widget_1_));

    //model.atom_prototype().kit().add_visual 
    //    (new OpenRM_atom (RM_widget_2_->object_node(), RM_widget_2_));

}

Model_RM_window::
~Model_RM_window ()
{
}

void Model_RM_window::
closeEvent (QCloseEvent * event)
{
    if (model_.kit().is_locked())
    {
        event->ignore ();
        return;
    }

    model_.erase();
}

Model_RM_widget * Model_RM_window::
current_model_widget ()
{
    QWidget * focus = focusWidget ();

    Model_RM_widget * result = dynamic_cast <Model_RM_widget *> (focus);

    if (result == 0)
        return RM_widget_1_;

    return result;
}

void Model_RM_window::
fit_to_screen ()
{
    RM_widget_1_->fit_to_screen ();
    RM_widget_2_->fit_to_screen ();
}

//fix
void Model_RM_window::
flush_camera (){}
void Model_RM_window::
set_level_of_details (int /*lod*/){}

void Model_RM_window::
set_focus ()
{
    //Main_window::singleton()->MDI_panel->setActiveSubWindow (this);
    this->setFocus();
}

void Model_RM_window::
renew ()
{
}

void Model_RM_window::
showEvent (QShowEvent * event)
{
    QWidget::showEvent (event); //fix move

    if (first_show_)
    {
        QList<int> old_sizes = splitter->sizes ();
        QList<int> new_sizes;
        int full_size = old_sizes[0] + old_sizes[1];
        new_sizes.push_back (full_size);
        new_sizes.push_back (0);
        splitter->setSizes (new_sizes);
        first_show_ = false;
    }
}

}//MM
