#ifndef NDEBUG

#include "Module.h"

#include "Path.h"
#include "Main_window.h"
#include "Model_RM_window.h"
#include "Model_RM_widget.h"

#include <rm/rm.h>


namespace MM
{

class Module_OpenRM : public Module
{
    static Module_OpenRM    singleton_;
                            Module_OpenRM() ;
    void                    init ();
};
Module_OpenRM  Module_OpenRM::singleton_;


Module_OpenRM::Module_OpenRM () : Module ("OpenRM") { }

void  Module_OpenRM::
init ()
{
    insert_menu_separator ("&Test");

    struct Print : public Command
    {
        void execute ()
        {
            Model_RM_window * window = (Model_RM_window*) 
                Main_window::singleton()->current_model_window ();

            Model_RM_widget * widget = window->current_model_widget ();

            rmPrintSceneGraph (widget->root_node_, RM_CHILL, 
                (Path::report() + "SceneGraph.txt").c_str());
        }
    };

    adopt_command (new Print)
        .set_menu       ("&Test", "&Print Scene Graph");

    insert_menu_separator ("&Test");
}

}//MM

#endif//NDEBUG
