#include "Module.h"

#include "Peep.h"

#include "Main_window.h"
#include "Model.h"
#include "Model_kit.h"

#include "Abstracts.h"
#include "Create.h"

#include <QMdiSubWindow>

namespace MM
{

class Module_Qt : public Module
{
    static Module_Qt        singleton_;
                            Module_Qt() ;
    void                    init ();
};
Module_Qt  Module_Qt::singleton_;


Module_Qt::Module_Qt () : Module ("Qt") { }

void  Module_Qt::
init ()
{
    struct Tile : public Command
    {void execute() {Main_window::singleton()->MDI_panel->tileSubWindows();}};

    struct Cascade : public Command
    {void execute() {Main_window::singleton()->MDI_panel->cascadeSubWindows();}};

    struct Minimize : public Command
    {
        void execute() 
        {
            Main_window::singleton()->MDI_panel->tileSubWindows();

            QList<QMdiSubWindow *> list = Main_window::singleton()->
                MDI_panel->subWindowList ();
            for (int i=0;  i<list.size ();  ++i)
                list[i]->showMinimized ();
        }
    };

    struct Maximize : public Command
    {
        void execute() 
        {
            QList<QMdiSubWindow *> list = Main_window::singleton()->
                MDI_panel->subWindowList ();
            for (int i=0;  i<list.size ();  ++i)
                list[i]->showMaximized ();
        }
    };

    struct Normal : public Command
    {
        void execute() 
        {
            QList<QMdiSubWindow *> list = Main_window::singleton()->
                MDI_panel->subWindowList ();
            for (int i=0;  i<list.size ();  ++i)
                list[i]->showNormal ();
        }
    };

    adopt_command (new Tile)
        //.set_icon       ("Window", "tile.png")
        .set_tool_tip   ("Tile windows.")
        .set_menu       ("&Window", "&Tile");

    adopt_command (new Cascade)
        //.set_icon       ("Window", "cascade.png")
        .set_tool_tip   ("Cascade windows.")
        .set_menu       ("&Window", "&Cascade");

    adopt_command (new Minimize)
        //.set_icon       ("Window", "cascade.png")
        .set_tool_tip   ("Minimize windows.")
        .set_menu       ("&Window", "&Minimize");

    adopt_command (new Maximize)
        //.set_icon       ("Window", "cascade.png")
        .set_tool_tip   ("Maximize windows.")
        .set_menu       ("&Window", "&Maximize");

    adopt_command (new Normal)
        //.set_icon       ("Window", "cascade.png")
        .set_tool_tip   ("Normal windows.")
        .set_menu       ("&Window", "&Normal");

    //adopt_command (prototype <Open> ().clone())
    //    .set_icon       ("File", "open.png")
    //    .set_tool_tip   ("Load model from file.")
    //    .set_menu       ("&File", "&Open");

    //insert_menu_separator ("&File");
}

}//MM
