#ifndef OPENRMWIDGET_H
#define OPENRMWIDGET_H

#include <QGLWidget>

//#include <rm/rm.h>

/*
#ifdef RM_WIN
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#ifdef RM_X
#ifndef GLX_GLXEXT_PROTOTYPES
#define GLX_GLXEXT_PROTOTYPES
#endif
//#include <GL/glx.h>
#endif

#ifdef RM_CR
#include <chromium.h>
#endif

#include <math.h>
#include <time.h>

#ifdef RM_DLL_EXPORTS
#define RM_EXPORT_API _declspec(dllexport)
#define RM_EXPORT_VAR 
#else
#define RM_EXPORT_API
#define RM_EXPORT_VAR 
#endif

#include <rm/rmdefs.h>
#include <rm/rmtypes.h>
//*/
extern "C" {

struct RMnode;
struct RMpipe;
struct RMfog;
struct RMtime;

/*typedef struct
{
    long sec;
    long usec;
} RMtime;//*/


struct RMcamera3D;
}//*/

class QMouseEvent;
class QTimerEvent;
class QPaintEvent;
class QCloseEvent;

class OpenRMWidget : public QGLWidget
{
    Q_OBJECT

public:
    RMnode *        root_node_;
    RMnode *        camera_node_;
    RMnode *        scene_node_;          
    RMnode *        object_node_; 

    RMpipe *        pipe_;
            
    RMfog  *        fog_;
    RMtime *        time_1_;
    RMtime *        time_2_;
    
    QPoint          last_position_;
    QPoint          last_press_position_;

public:
    explicit        OpenRMWidget (QWidget *parent);
    virtual        ~OpenRMWidget();

    double          eye_distance     () const;
    void            set_eye_distance (double distance);

    void            fit (double & center_x,
                         double & center_y,
                         double & center_z,
                         double & scale);

public slots:
    void            flush_camera  ();

    //void            demo_rotation (int steps);

protected:
    virtual void    set_level_of_details (int lod) =0;

    double          eye_distance     (RMcamera3D *camera) const;
    void            set_eye_distance (RMcamera3D *camera, double distance);

    void            paintEvent (QPaintEvent *event) ;

    void            initializeGL ();
    void            resizeGL (int width, int height);
    void            paintGL ();

    //void            keyPressEvent           (QKeyEvent   * event);
    void            mousePressEvent         (QMouseEvent * event);
    void            mouseMoveEvent          (QMouseEvent * event);
    void            closeEvent              (QCloseEvent * e);

    void            create_lighting ();
    void            create_light_model ();
    void            create_camera   ();
};

#endif //OPENRMWIDGET_H
