#ifndef PANEL_H
#define PANEL_H

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#include <QWidget>
//#include <QTimer>

namespace MM
{
class Model;
class Model_RM_window;
class Model_RM_widget;

class Panel : public QWidget, protected DbC
{
    Text                title_;
    Text                layout_;
    //QTimer              timer_;

public:        
    explicit            Panel (Text const & title, Text const & layout);
    virtual            ~Panel();

    Model_RM_window *   window  ();
    Model_RM_widget *   widget  ();
    Model &             model   ();

public slots:
    virtual void        popup ();

protected:
    void                add_to_tab ();

    void                showEvent  (QShowEvent  * event);
    void                hideEvent  (QHideEvent  * event);
    void                closeEvent (QCloseEvent * event);
    virtual void        turn (bool) {}
};

}//MM

#endif //PANEL_H
