#include "Panel_add_model.h"

#include "Model_kit.h"

#include "Main_window.h"
#include "Model_RM_window.h"
#include "Model_RM_widget.h"
#include "OpenRMWidget.h"
#include "Angle_unit.h"
#include "Panel_move_model.h"

namespace MM
{

Panel_add_model::
Panel_add_model ()
:
    Panel ("Add", "middle"),
    window_(0),                        
    builder_(0),
    timer_(this),
    accepted_(false)
{
    setupUi (this);

    connect (&timer_, SIGNAL(timeout()), this, SLOT(flush_Z_viewpoint()));
    timer_.start(1000);

    connect(pushButton_OK,              SIGNAL (clicked()), 
            this,                       SLOT   (accept()));

    connect(pushButton_Cancel,          SIGNAL (clicked()), 
            this,                       SLOT   (destroy()));

    connect(checkBox_Remove_overlaped,  SIGNAL (toggled   (bool)), 
            this,                       SLOT   (no_overlap(bool)));

    connect(radioButton_Remove_overlap_from_current,    SIGNAL (toggled(bool)),
            this,                       SLOT (remove_overlap_from_current(bool)));

    connect(radioButton_Remove_overlap_from_addition,   SIGNAL (toggled(bool)),
            this,                       SLOT (remove_overlap_from_addition(bool)));

    connect(radioButton_Move_current,   SIGNAL (toggled(bool)),
            this,                       SLOT (move_current(bool)));

    connect(radioButton_Move_addition,  SIGNAL (toggled(bool)),
            this,                       SLOT (move_addition(bool)));

    QMenu * file_menu = Main_window::singleton()->menu("&File");
    for (int i=0;  i<file_menu->actions ().count();  ++i)
    {
        QAction * action = file_menu->actions().at(i);
        QString title = action->text();

        if (title == "&Add")
            action->setEnabled (false);
    }
}

Panel_add_model::           
~Panel_add_model ()
{
    Panel_move_model::singleton()->close();     //fix
    delete Panel_move_model::singleton();
    Main_window::singleton()->min_right_panel ();
}

void Panel_add_model::
closeEvent (QCloseEvent * /*event*/)
{
    timer_.stop ();
    disconnect (window_, 0, this, 0);
    
    move_current (true);

    if (!accepted_)
        builder ().reject ();

    QMenu * file_menu = Main_window::singleton()->menu("&File");
    for (int i=0;  i<file_menu->actions ().count();  ++i)
    {
        QAction * action = file_menu->actions().at(i);
        QString title = action->text();

        if (title == "&Add")
            action->setEnabled (true);
    }

    desplit ();
}

void Panel_add_model::
execute ()
{
    if (builder_ != 0)
    {
        disconnect (window_, 0, this, 0);
        builder_->reject ();
    }

    window_  = window ();
    builder_ = &model().kit().add_builder ();

    split ();
    connect (window_, SIGNAL(destroyed (QObject*)), this, SLOT(destroy()));

    remove_overlap_from_addition (true);
    move_current                 (true);

    popup ();
}

Add_builder & Panel_add_model::
builder ()
{
    return  *builder_;
}

void Panel_add_model::
split ()
{
    QSplitter * splitter = window_->splitter;

    QList<int> old_sizes = splitter->sizes ();
    QList<int> new_sizes;
    int full_size = old_sizes[0] + old_sizes[1];

    new_sizes.push_back (full_size/2);
    new_sizes.push_back (full_size - full_size/2);

    splitter->setSizes (new_sizes);

    window_->RM_widget_2_->setFocus ();
    window_->RM_widget_2_->right_Y_view (Angle_unit().set_deg(90));
}

void Panel_add_model::
desplit ()
{
    QSplitter * splitter = window_->splitter;

    QList<int> old_sizes = splitter->sizes ();
    QList<int> new_sizes;
    int full_size = old_sizes[0] + old_sizes[1];

    new_sizes.push_back (full_size);
    new_sizes.push_back (0);

    splitter->setSizes (new_sizes);

    window_->RM_widget_1_->setFocus ();
}

void Panel_add_model::
destroy ()
{
    //delete this;
    close();
}

void Panel_add_model::
accept ()
{
    accepted_ = true;
    builder ().accept ();
    destroy ();
}

void Panel_add_model::
flush_Z_viewpoint ()
{
    window_->RM_widget_1_->flush_camera ();
}

void Panel_add_model::
no_overlap (bool on)
{
    builder().allow_overlap (!on);
}

void Panel_add_model::
remove_overlap_from_current (bool on)
{
    builder().remove_overlap_in_additional_model (!on);
}

void Panel_add_model::
remove_overlap_from_addition (bool on)
{
    builder().remove_overlap_in_additional_model (on);
}

void Panel_add_model::
move_current (bool on)
{
    builder().move_current_model (on);
}

void Panel_add_model::
move_addition (bool on)
{
    builder().move_current_model (!on);
}

}//MM
