#include "Panel_force_field.h"

#include "Model.h"
#include "Model_kit.h"
#include "Force_field.h"

namespace MM
{

Panel_force_field::
Panel_force_field ()
:
    Panel ("FF", "right")
{
    setupUi (this);

    comboBox_sigma  ->hide();
    comboBox_epsilon->hide();
    label_I         ->hide();
    doubleSpinBox_I ->hide();

    connect(doubleSpinBox_eps,  SIGNAL(valueChanged(double)),
            this,               SLOT(set_dielectric_permittivity (double)));

    connect(doubleSpinBox_14_Electrostatic,  SIGNAL(valueChanged(double)),
            this,               SLOT(set_14_Electrostatic (double)));

    connect(doubleSpinBox_14_VdW,  SIGNAL(valueChanged(double)),
            this,               SLOT(set_14_VdW (double)));

    connect(doubleSpinBox_Rm,  SIGNAL(valueChanged(double)),
            this,               SLOT(set_Rm (double)));

    connect(doubleSpinBox_I,  SIGNAL(valueChanged(double)),
            this,               SLOT(set_I (double)));

    renew ();
}

void Panel_force_field::
renew ()
{
    renew (Model_event::Structure_changed);
}

void Panel_force_field::
renew_current_model (Model &)
{
    renew (Model_event::Structure_changed);
}

void Panel_force_field::
renew (Model_event::Hint)
{
    Model_kit  &           kit = model().kit();
    //Common_interactions &  interactions = kit.interaction().common();
    Force_field &          ff = kit.force_field ();

    doubleSpinBox_eps               ->blockSignals (true);
    doubleSpinBox_14_Electrostatic  ->blockSignals (true);
    doubleSpinBox_14_VdW            ->blockSignals (true);
    doubleSpinBox_Rm                ->blockSignals (true);
    doubleSpinBox_I                 ->blockSignals (true);

    label_Name ->setText  (QString(
        "<span style=\" font-size:13pt; font-style:italic;\">") 
        + QString (ff.name ()) + "</span>");

    doubleSpinBox_eps               ->setValue (ff.eps);
    doubleSpinBox_14_Electrostatic  ->setValue (ff.E_Static_Scale);
    doubleSpinBox_14_VdW            ->setValue (ff.VdW_Scale);
    //comboBox_sigma                  ->setCurrentIndex (
    //    comboBox_sigma->findText(ff.sigma_rule_));
    //comboBox_epsilon                ->setCurrentIndex 
    //    (comboBox_epsilon->findText(ff.epsilon_rule_));
    label_sigma  ->setText (QString()+"Sigma   is "+QString(ff.sigma_rule_));
    label_epsilon->setText (QString()+"Epsilon is "+QString(ff.epsilon_rule_));
    doubleSpinBox_Rm                ->setValue (ff.Rm_);
    doubleSpinBox_I                 ->setValue (ff.I_);

    doubleSpinBox_eps               ->blockSignals (false);
    doubleSpinBox_14_Electrostatic  ->blockSignals (false);
    doubleSpinBox_14_VdW            ->blockSignals (false);
    doubleSpinBox_Rm                ->blockSignals (false);
    doubleSpinBox_I                 ->blockSignals (false);
}

void Panel_force_field::
set_dielectric_permittivity (double v)
{
    model().kit().interaction().common().set_epsilon (v);
}

void Panel_force_field::set_14_Electrostatic        (double v)
{model().kit().force_field().E_Static_Scale = v;}
void Panel_force_field::set_14_VdW                  (double v)
{model().kit().force_field().VdW_Scale = v;}
void Panel_force_field::set_Rm                      (double v)
{model().kit().force_field().Rm_ = v;}
void Panel_force_field::set_I                       (double v)
{model().kit().force_field().I_ = v;}

}//MM
