#ifndef PANEL_GEOMETRY_H
#define PANEL_GEOMETRY_H

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef MODEL_SINGLETON_VIEW_H
#include "Model_singleton_view.h"
#endif

#ifndef UI_PANEL_GEOMETRY_H
#include "ui_Panel_geometry.h"
#endif

#ifndef LENGTH_UNIT_H
#include "Length_unit.h"
#endif

#ifndef ANGLE_UNIT_H
#include "Angle_unit.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

#ifndef COMMAND_H
#include "Command.h"
#endif

namespace MM
{
class Point_3D;

class Panel_geometry 
:
    public Panel,
    public Ui_Panel_geometry,
    public Model_singleton_view,
    public Dynamic_singleton <Panel_geometry>
{
    Q_OBJECT

    int                 old_slider_;
    Command_1 <Atom&> * add_atom_;

public:    
    Panel_geometry ();
   ~Panel_geometry ();

    void            renew_current_model (Model &);
    void            renew (Model_event::Hint);
    
    void            add_atom (Atom & atom);

public slots:
    void            renew ();

    void            set_point_type (const QString &);
    void            set_ID         (const QString &);
    void            set_space_position_1 ();
    void            set_space_position_2 ();
    void            set_space_position_3 ();
    void            set_space_position_4 ();

    void            measure_distance       (bool);
    void            measure_angle          (bool);
    void            measure_dihedral_angle (bool);

    void            set_value (double);
    void            set_value (int   );
    void            add_value (double);

    void            set_distance       ();
    void            increment_distance ();
    void            decrement_distance ();

    void            set_angle       ();
    void            increment_angle ();
    void            decrement_angle ();

    void            stackedWidgetChanged (int);

    void            restrain ();
    void            fix ();

protected:
    void            showEvent (QShowEvent * event);

    int             measured_count ();
    bool            get_space_position (int point_N,      Point_3D & result);
    bool            get_space_position (QLineEdit * edit, Point_3D & result);
};

}//MM

#endif //PANEL_GEOMETRY_H
