#ifndef PANEL_MONITORS_H
#define PANEL_MONITORS_H

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef MODEL_SINGLETON_VIEW_H
#include "Model_singleton_view.h"
#endif

#ifndef UI_PANEL_MONITORS_H
#include "ui_Panel_monitors.h"
#endif

#ifndef TIMER_H
#include "Timer.h"
#endif

#include <QTimer>

namespace MM
{

class Panel_monitors
:
    public Panel,
    public Ui_Panel_monitors,
    public Model_singleton_view,
    public Dynamic_singleton <Panel_monitors>
{
    Q_OBJECT

    Timer  timer_;
    QTimer qtimer_;

    bool   update_flag_;

public:    
    Panel_monitors ();

    void    renew_current_model (Model &);
    void    renew (Model_event::Hint hint = Model_event::Structure_changed);

public slots:
    void            renew_values ();
    void            update_ready ();

    void            make_monitor ();
    void            show_plot    ();
    void            turn_on (int);
    void            set_observation_period (int p);

protected:
    void showEvent (QShowEvent * event);
};

}//MM

#endif //PANEL_MONITORS_H
