#include "Panel_move_model.h"

#include "Path.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"

#include "Model_RM_window.h"
#include "Model_RM_widget.h"

#include <qvalidator.h>

#include <math.h>

namespace MM
{

Panel_move_model::
Panel_move_model ()
:
    Panel ("Move", "right")
{
    setupUi (this);

    toolButton_left_X ->setIcon(QIcon((Path::icon() + "left_X.png").c_str()));
    connect(toolButton_left_X,  SIGNAL(clicked()), 
            this,               SLOT(left_X()));

    toolButton_right_X->setIcon(QIcon((Path::icon() + "right_X.png").c_str()));
    connect(toolButton_right_X, SIGNAL(clicked()), 
            this,               SLOT(right_X()));

    toolButton_left_Y ->setIcon(QIcon((Path::icon() + "left_Y.png").c_str()));
    connect(toolButton_left_Y,  SIGNAL(clicked()), 
            this,               SLOT(left_Y()));

    toolButton_right_Y->setIcon(QIcon((Path::icon() + "right_Y.png").c_str()));
    connect(toolButton_right_Y, SIGNAL(clicked()), 
            this,               SLOT(right_Y()));

    toolButton_left_Z ->setIcon(QIcon((Path::icon() + "left_Z.png").c_str()));
    connect(toolButton_left_Z,  SIGNAL(clicked()), 
            this,               SLOT(left_Z()));

    toolButton_right_Z->setIcon(QIcon((Path::icon() + "right_Z.png").c_str()));
    connect(toolButton_right_Z, SIGNAL(clicked()), 
            this,               SLOT(right_Z()));

    connect(lineEdit_Rotation,  SIGNAL(editingFinished()), 
            this,               SLOT(set_rotation_increment()));
    //lineEdit_Rotation->setValidator (new QDoubleValidator (this)); 
    rotation_increment_.set_current_type ("deg");
    renew_rotation_increment ();



    toolButton_left->setIcon (QIcon((Path::icon() + "left.png").c_str()));
    connect(toolButton_left,    SIGNAL(clicked()), 
            this,               SLOT(left()));

    toolButton_right->setIcon (QIcon((Path::icon() + "right.png").c_str()));
    connect(toolButton_right,   SIGNAL(clicked()), 
            this,               SLOT(right()));

    toolButton_up->setIcon (QIcon((Path::icon() + "up.png").c_str()));
    connect(toolButton_up,      SIGNAL(clicked()), 
            this,               SLOT(up()));

    toolButton_down->setIcon (QIcon((Path::icon() + "down.png").c_str()));
    connect(toolButton_down,    SIGNAL(clicked()), 
            this,               SLOT(down()));
    
    toolButton_out->setIcon (QIcon((Path::icon() + "out.png").c_str()));
    connect(toolButton_out,     SIGNAL(clicked()), 
            this,               SLOT(out()));

    toolButton_in->setIcon (QIcon((Path::icon() + "in.png").c_str()));
    connect(toolButton_in,      SIGNAL(clicked()), 
            this,               SLOT(in()));

    connect(lineEdit_Translation,   SIGNAL(editingFinished()), 
            this,       SLOT(set_translation_increment()));
    //lineEdit_Translation->setValidator (new QDoubleValidator (this)); 
    translation_increment_.set_current_type ("A");
    renew_translation_increment ();



    toolButton_view_up->
        setIcon (QIcon((Path::icon() + "up.png"   ).c_str()));
    connect(toolButton_view_up,         SIGNAL(clicked()), 
            this,                       SLOT(right_X_view()));

    toolButton_view_down->
        setIcon (QIcon((Path::icon() + "down.png" ).c_str()));
    connect(toolButton_view_down,       SIGNAL(clicked()), 
            this,                       SLOT(left_X_view()));

    toolButton_view_left->
        setIcon (QIcon((Path::icon() + "left.png" ).c_str()));
    connect(toolButton_view_left,       SIGNAL(clicked()), 
            this,                       SLOT(left_Y_view()));

    toolButton_view_right->
        setIcon (QIcon((Path::icon() + "right.png").c_str()));
    connect(toolButton_view_right,      SIGNAL(clicked()), 
            this,                       SLOT(right_Y_view()));

    toolButton_view_left_Z->
        setIcon (QIcon((Path::icon() + "left_Z.png" ).c_str()));
    connect(toolButton_view_left_Z,     SIGNAL(clicked()), 
            this,                       SLOT(left_Z_view()));

    toolButton_view_right_Z->
        setIcon (QIcon((Path::icon() + "right_Z.png").c_str()));
    connect(toolButton_view_right_Z,    SIGNAL(clicked()), 
            this,                       SLOT(right_Z_view()));

    connect(lineEdit_Viewpoint,   SIGNAL(editingFinished()), 
            this,       SLOT(set_viewpoint_increment()));
    //lineEdit_Viewpoint->setValidator (new QDoubleValidator (this)); 
    viewpoint_increment_.set_current_type ("deg");
    viewpoint_increment_.set_deg (90.);
    renew_viewpoint_increment ();


    toolButton_flush_camera->
        setIcon (QIcon((Path::icon() + "flush_camera.png").c_str()));
    connect(toolButton_flush_camera,    SIGNAL(clicked()), 
            this,                       SLOT(flush_camera()));

}

Add_builder & Panel_move_model::
builder ()
{
    return  model().kit().add_builder();
}

void Panel_move_model::left_X  ()   {builder().left_X  ();}
void Panel_move_model::right_X ()   {builder().right_X ();}
void Panel_move_model::left_Y  ()   {builder().left_Y  ();}
void Panel_move_model::right_Y ()   {builder().right_Y ();}
void Panel_move_model::left_Z  ()   {builder().left_Z  ();}
void Panel_move_model::right_Z ()   {builder().right_Z ();}

//void Panel_move_model::
//set_rotation_increment (const QString & increment)
//{
//    rotation_increment_.from_text (increment.latin1 ());
//    builder().set_rotation_increment (rotation_increment_.rad ());
//    update ();
//}

void Panel_move_model::
set_rotation_increment ()
{
    rotation_increment_.from_text (lineEdit_Rotation->text());
    builder().set_rotation_increment (rotation_increment_.rad ());
    renew_rotation_increment ();
}

void Panel_move_model::
renew_rotation_increment ()
{
    rotation_increment_.set_rad (builder().rotation_increment ());
    lineEdit_Rotation->blockSignals (true);
    lineEdit_Rotation->setText (rotation_increment_.text ());
    lineEdit_Rotation->blockSignals (false);
}

void Panel_move_model::left  ()     {builder().left  ();}
void Panel_move_model::right ()     {builder().right ();}
void Panel_move_model::up    ()     {builder().up    ();}
void Panel_move_model::down  ()     {builder().down  ();}
void Panel_move_model::out   ()     {builder().out   ();}
void Panel_move_model::in    ()     {builder().in    ();}

void Panel_move_model::
set_translation_increment ()
{
    translation_increment_.from_text (lineEdit_Translation->text());
    builder().set_translation_increment (translation_increment_.A ());
    renew_translation_increment ();
}

void Panel_move_model::
renew_translation_increment ()
{
    translation_increment_.set_A (builder().translation_increment ());
    lineEdit_Translation->blockSignals (true);
    lineEdit_Translation->setText (translation_increment_.text ());
    lineEdit_Translation->blockSignals (false);
}

void Panel_move_model::right_X_view ()
    {widget()->right_X_view (viewpoint_increment_);}

void Panel_move_model::left_X_view  ()
    {widget()->left_X_view (viewpoint_increment_);}

void Panel_move_model::right_Y_view ()
    {widget()->right_Y_view (viewpoint_increment_);}

void Panel_move_model::left_Y_view  ()
    {widget()->left_Y_view (viewpoint_increment_);}

void Panel_move_model::right_Z_view ()
    {widget()->right_Z_view (viewpoint_increment_);}

void Panel_move_model::left_Z_view  ()
    {widget()->left_Z_view (viewpoint_increment_);}


void Panel_move_model::
set_viewpoint_increment ()
{
    viewpoint_increment_.from_text (lineEdit_Viewpoint->text());
    renew_viewpoint_increment ();
}

void Panel_move_model::
renew_viewpoint_increment ()
{
    lineEdit_Viewpoint->blockSignals (true);
    lineEdit_Viewpoint->setText (viewpoint_increment_.text ());
    lineEdit_Viewpoint->blockSignals (false);
}

void Panel_move_model::
flush_camera ()
{
    widget ()->flush_camera();
}

}//MM
