#ifndef PANEL_MOVE_MODEL_H
#define PANEL_MOVE_MODEL_H

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef UI_PANEL_MOVE_MODEL_H
#include "ui_Panel_move_model.h"
#endif

#ifndef LENGTH_UNIT_H
#include "Length_unit.h"
#endif

#ifndef ANGLE_UNIT_H
#include "Angle_unit.h"
#endif

namespace MM
{
class Add_builder;

class Panel_move_model 
:
    public Panel,
    public Ui_Panel_move_model,
    public Dynamic_singleton <Panel_move_model>
{
    Q_OBJECT

    Angle_unit          rotation_increment_;
    Length_unit         translation_increment_;
    Angle_unit          viewpoint_increment_;

    Add_builder &       builder ();

public:    
    Panel_move_model();

public slots:
    void                right_X ();
    void                left_X  ();
    void                right_Y ();
    void                left_Y  ();
    void                right_Z ();
    void                left_Z  ();

    void                set_rotation_increment ();
    void                renew_rotation_increment ();

    void                left    ();
    void                right   ();
    void                up      ();
    void                down    ();
    void                out     ();
    void                in      ();

    void                set_translation_increment ();
    void                renew_translation_increment ();

    void                right_X_view ();
    void                left_X_view  ();
    void                right_Y_view ();
    void                left_Y_view  ();
    void                right_Z_view ();
    void                left_Z_view  ();

    void                set_viewpoint_increment ();
    void                renew_viewpoint_increment ();

    void                flush_camera ();

//protected:
};

}//MM

#endif //PANEL_MOVE_MODEL_H
