#include "Panel_nano.h"

#include "Path.h"
#include "Model.h"
#include "Model_kit.h"

namespace MM
{

Panel_nano::
Panel_nano ()
:
    Panel ("Nano", "right")
{
    setupUi (this);

    toolButton_1->setIcon (QIcon(Path::nano() + "BuckyBall.png"));
    toolButton_2->setIcon (QIcon(Path::nano() + "BuckyBall-5.png"));
    toolButton_3->setIcon (QIcon(Path::nano() + "BuckyBall-10.png"));
    toolButton_4->setIcon (QIcon(Path::nano() + "BuckyBall-20.png"));
    toolButton_5->setIcon (QIcon(Path::nano() + "BuckyBall-30.png"));
    toolButton_6->setIcon (QIcon(Path::nano() + "BuckyBall-40.png"));
    toolButton_7->setIcon (QIcon(Path::nano() + "BuckyBall-50.png"));
    toolButton_8->setIcon (QIcon(Path::nano() + "BuckyBall-55.png"));

    toolButton_1->setToolTip ("BuckyBall");
    toolButton_2->setToolTip ("BuckyBall without 5 atoms");
    toolButton_3->setToolTip ("BuckyBall without 10 atoms");
    toolButton_4->setToolTip ("BuckyBall without 20 atoms");
    toolButton_5->setToolTip ("BuckyBall without 30 atoms");
    toolButton_6->setToolTip ("BuckyBall without 40 atoms");
    toolButton_7->setToolTip ("BuckyBall without 50 atoms");
    toolButton_8->setToolTip ("BuckyBall without 55 atoms");


    toolButton_9 ->setIcon (QIcon(Path::nano() + "Nanotube_(5, 5) Armchair.png"));
    toolButton_10->setIcon (QIcon(Path::nano() + "Nanotube_(10, 10) Armchair.png"));
    toolButton_11->setIcon (QIcon(Path::nano() + "Nanotube_(17, 0) Zigzag.png"));
    toolButton_12->setIcon (QIcon(Path::nano() + "Nanotube_(12, 6) Chiral.png"));

    toolButton_9 ->setToolTip ("Nanotube (5, 5) Armchair");
    toolButton_10->setToolTip ("Nanotube (10, 10) Armchair");
    toolButton_11->setToolTip ("Nanotube (17, 0) Zigzag");
    toolButton_12->setToolTip ("Nanotube (12, 6) Chiral");

    toolButton_13->setIcon (QIcon(Path::nano() + "Nanocone_060-10.png"));
    toolButton_14->setIcon (QIcon(Path::nano() + "Nanocone_120-10.png"));
    toolButton_15->setIcon (QIcon(Path::nano() + "Nanocone_180-10.png"));
    toolButton_16->setIcon (QIcon(Path::nano() + "Nanocone_240-20.png"));
    toolButton_17->setIcon (QIcon(Path::nano() + "Nanocone_240-30.png"));
    toolButton_18->setIcon (QIcon(Path::nano() + "Nanocone_300-20.png"));
    toolButton_19->setIcon (QIcon(Path::nano() + "Nanocone_300-30.png"));
    toolButton_20->setIcon (QIcon(Path::nano() + "Nanocone_300-40.png"));

    toolButton_13->setToolTip ("Nanocone  60 deg  10 A");
    toolButton_14->setToolTip ("Nanocone  120 deg  10 A");
    toolButton_15->setToolTip ("Nanocone  180 deg  10 A");
    toolButton_16->setToolTip ("Nanocone  240 deg  20 A");
    toolButton_17->setToolTip ("Nanocone  240 deg  30 A");
    toolButton_18->setToolTip ("Nanocone  300 deg  20 A");
    toolButton_19->setToolTip ("Nanocone  300 deg  30 A");
    toolButton_20->setToolTip ("Nanocone  300 deg  40 A");

    connect(toolButton_1,  SIGNAL (clicked()),  this, SLOT (load_1()));
    connect(toolButton_2,  SIGNAL (clicked()),  this, SLOT (load_2()));
    connect(toolButton_3,  SIGNAL (clicked()),  this, SLOT (load_3()));
    connect(toolButton_4,  SIGNAL (clicked()),  this, SLOT (load_4()));
    connect(toolButton_5,  SIGNAL (clicked()),  this, SLOT (load_5()));
    connect(toolButton_6,  SIGNAL (clicked()),  this, SLOT (load_6()));
    connect(toolButton_7,  SIGNAL (clicked()),  this, SLOT (load_7()));
    connect(toolButton_8,  SIGNAL (clicked()),  this, SLOT (load_8()));
    connect(toolButton_9,  SIGNAL (clicked()),  this, SLOT (load_9()));
    connect(toolButton_10, SIGNAL (clicked()),  this, SLOT (load_10()));
    connect(toolButton_11, SIGNAL (clicked()),  this, SLOT (load_11()));
    connect(toolButton_12, SIGNAL (clicked()),  this, SLOT (load_12()));
    connect(toolButton_13, SIGNAL (clicked()),  this, SLOT (load_13()));
    connect(toolButton_14, SIGNAL (clicked()),  this, SLOT (load_14()));
    connect(toolButton_15, SIGNAL (clicked()),  this, SLOT (load_15()));
    connect(toolButton_16, SIGNAL (clicked()),  this, SLOT (load_16()));
    connect(toolButton_17, SIGNAL (clicked()),  this, SLOT (load_17()));
    connect(toolButton_18, SIGNAL (clicked()),  this, SLOT (load_18()));
    connect(toolButton_19, SIGNAL (clicked()),  this, SLOT (load_19()));
    connect(toolButton_20, SIGNAL (clicked()),  this, SLOT (load_20()));
}

void Panel_nano::load_1 () {load ("BuckyBall.mlm");}
void Panel_nano::load_2 () {load ("BuckyBall-5.mlm");}
void Panel_nano::load_3 () {load ("BuckyBall-10.mlm");}
void Panel_nano::load_4 () {load ("BuckyBall-20.mlm");}
void Panel_nano::load_5 () {load ("BuckyBall-30.mlm");}
void Panel_nano::load_6 () {load ("BuckyBall-40.mlm");}
void Panel_nano::load_7 () {load ("BuckyBall-50.mlm");}
void Panel_nano::load_8 () {load ("BuckyBall-55.mlm");}

void Panel_nano::load_9 () {load ("Nanotube_(5, 5) Armchair.mlm");}
void Panel_nano::load_10() {load ("Nanotube_(10, 10) Armchair.mlm");}
void Panel_nano::load_11 (){load ("Nanotube_(17, 0) Zigzag.mlm");}
void Panel_nano::load_12 (){load ("Nanotube_(12, 6) Chiral.mlm");}

void Panel_nano::load_13 (){load ("Nanocone_060-10.mlm");}
void Panel_nano::load_14 (){load ("Nanocone_120-10.mlm");}
void Panel_nano::load_15 (){load ("Nanocone_180-10.mlm");}
void Panel_nano::load_16 (){load ("Nanocone_240-20.mlm");}
void Panel_nano::load_17 (){load ("Nanocone_240-30.mlm");}
void Panel_nano::load_18 (){load ("Nanocone_300-20.mlm");}
void Panel_nano::load_19 (){load ("Nanocone_300-30.mlm");}
void Panel_nano::load_20 (){load ("Nanocone_300-40.mlm");}

void Panel_nano::
load (Text const & file)
{
    Text file_name = model().kit().file_name ();//fix

    if (comboBox->currentText() == "Add")
        model().kit().add_builder().load ((Path::nano() + file).c_str());
    
    else
        model().load (Path::nano() + file);

    model().kit().set_file_name (file_name);//fix
}

}//MM
