#include "Panel_performance.h"

#include "List_interactions.h"
#include "Model.h"
#include "Model_kit.h"
#include "MD_simulator.h"
#include "MD_method.h"
#include "MTS.h"

#include "rRESPA_4.h"

namespace MM
{

Panel_performance::
Panel_performance ()
:
    Panel ("Performance", "right")
{
    setupUi (this);
    
    connect(checkBox_use_atom_pair_lists,   SIGNAL(stateChanged(int)), 
            this,                      SLOT(use_atom_pair_lists(int)));

    connect(spinBox_list,           SIGNAL(valueChanged(int)), 
            this,                   SLOT(set_list_1(int)));
    connect(spinBox_list_2,         SIGNAL(valueChanged(int)), 
            this,                   SLOT(set_list_2(int)));
    connect(spinBox_list_3,         SIGNAL(valueChanged(int)), 
            this,                   SLOT(set_list_3(int)));

    connect(doubleSpinBox_Skin,     SIGNAL(valueChanged   (double)),
            this,                   SLOT(set_Skin  (double)));
    connect(doubleSpinBox_Skin_2,   SIGNAL(valueChanged   (double)),
            this,                   SLOT(set_Skin_2(double)));
    connect(doubleSpinBox_Skin_3,   SIGNAL(valueChanged   (double)),
            this,                   SLOT(set_Skin_3(double)));

    connect(doubleSpinBox_Switch,   SIGNAL(valueChanged   (double)),
            this,                   SLOT(set_Switch (double)));

    connect(checkBox_cut_large_forces,   SIGNAL(stateChanged(int)), 
            this,                        SLOT(cut_large_forces(int)));

    renew_values ();
}

Panel_performance::
~Panel_performance ()
{
}

void Panel_performance::
renew_values ()
{
    MD_method * method = &model().kit().MD().method();

    label_1             ->hide();
    label_2             ->hide();
    label_3             ->hide();
    spinBox_list        ->show();
    spinBox_list_2      ->hide();
    spinBox_list_3      ->hide();
    doubleSpinBox_Skin  ->show();
    doubleSpinBox_Skin_2->hide();
    doubleSpinBox_Skin_3->hide();
    doubleSpinBox_Switch->hide();
    label_Switch        ->hide();

    if (dynamic_cast<rRESPA_4*>(method))
    {
        rRESPA_4 * md_method = dynamic_cast<rRESPA_4 *>(method);

        checkBox_use_atom_pair_lists->setEnabled(false);
        List_interactions::set_on (true);

        label_1             ->show();
        label_2             ->show();
        label_3             ->show();
        spinBox_list        ->show();
        spinBox_list_2      ->show();
        spinBox_list_3      ->show();
        doubleSpinBox_Skin  ->show();
        doubleSpinBox_Skin_2->show();
        doubleSpinBox_Skin_3->show();
        doubleSpinBox_Switch->show();

        spinBox_list_3      ->blockSignals (true);
        spinBox_list_2      ->blockSignals (true);
        spinBox_list        ->blockSignals (true);
        doubleSpinBox_Skin  ->blockSignals (true);
        doubleSpinBox_Skin_2->blockSignals (true);
        doubleSpinBox_Skin_3->blockSignals (true);
        doubleSpinBox_Switch->blockSignals (true);

        spinBox_list_3->setValue (md_method->update_list_3());
        spinBox_list_2->setValue (md_method->update_list_2());
        spinBox_list  ->setValue (md_method->update_list  ());

        doubleSpinBox_Skin_3->setValue (md_method->skin_3());
        doubleSpinBox_Skin_2->setValue (md_method->skin_2());
        doubleSpinBox_Skin  ->setValue (md_method->skin());
        doubleSpinBox_Switch->setValue (md_method->Switch());

        spinBox_list_3      ->blockSignals (false);
        spinBox_list_2      ->blockSignals (false);
        spinBox_list        ->blockSignals (false);
        doubleSpinBox_Skin  ->blockSignals (false);
        doubleSpinBox_Skin_2->blockSignals (false);
        doubleSpinBox_Skin_3->blockSignals (false);
        doubleSpinBox_Switch->blockSignals (false);
    }
    else if (dynamic_cast<MTS*>(method))
    {
        MTS * md_method = dynamic_cast<MTS *>(method);

        checkBox_use_atom_pair_lists->setEnabled(false);
        List_interactions::set_on (true);

        doubleSpinBox_Switch->show();

        spinBox_list->blockSignals (true);
        doubleSpinBox_Skin   ->blockSignals (true);
        doubleSpinBox_Switch->blockSignals (true);

        spinBox_list->setValue (md_method->update_list  ());
        doubleSpinBox_Skin  ->setValue (md_method->skin());
        doubleSpinBox_Switch->setValue (md_method->Switch());

        spinBox_list->blockSignals (false);
        doubleSpinBox_Skin  ->blockSignals (false);
        doubleSpinBox_Switch->blockSignals (false);
    }
    else
    {
        checkBox_use_atom_pair_lists->setEnabled(true);
        List_interactions::set_on (checkBox_use_atom_pair_lists->isChecked());

        spinBox_list        ->blockSignals (true);
        doubleSpinBox_Skin  ->blockSignals (true);

        spinBox_list->setValue (method->update_list  ());
        doubleSpinBox_Skin  ->setValue (method->skin());

        spinBox_list        ->blockSignals (false);
        doubleSpinBox_Skin  ->blockSignals (false);
    }

    checkBox_use_atom_pair_lists->setChecked (List_interactions::is_on());
    
    //rRESPA_4 * md_method = dynamic_cast<rRESPA_4 *>(method);
    //if (md_method != 0)
    //{
    //    spinBox_list_3->setValue (md_method->update_list_3());
    //    spinBox_list_2->setValue (md_method->update_list_2());
    //    spinBox_list_1->setValue (md_method->update_list_1());
    //}

    checkBox_cut_large_forces->setChecked (MD_subject::to_cut_large_forces ());
}

void Panel_performance::
use_atom_pair_lists (int state)
{
    List_interactions::set_on (state);
}

void Panel_performance::
set_list_1 (int v)
{
    MD_method * method = &model().kit().MD().method();
    //MTS  * md_method = dynamic_cast<MTS *>(method);
    method->set_update_list (spinBox_list->value());
}

void Panel_performance::
set_list_2 (int v)
{
    MD_method * method = &model().kit().MD().method();
    rRESPA_4  * md_method = dynamic_cast<rRESPA_4 *>(method);
    md_method->set_update_list_2 (spinBox_list_2->value());
}

void Panel_performance::
set_list_3 (int v)
{
    MD_method * method = &model().kit().MD().method();
    rRESPA_4  * md_method = dynamic_cast<rRESPA_4 *>(method);
    md_method->set_update_list_3 (spinBox_list_3->value());
}


void Panel_performance::
set_Skin (double v)
{
    MD_method * method = &model().kit().MD().method();
//    MTS & method = dynamic_cast<MTS &>(model().kit().MD().method());
    method->set_skin (v);
}
void Panel_performance::
set_Skin_2 (double v)
{
    rRESPA_4 & method = dynamic_cast<rRESPA_4 &>(model().kit().MD().method());
    method.set_skin_2 (v);
}
void Panel_performance::
set_Skin_3 (double v)
{
    rRESPA_4 & method = dynamic_cast<rRESPA_4 &>(model().kit().MD().method());
    method.set_skin_3 (v);
}

void Panel_performance::
set_Switch (double v)
{
    MD_method * method = &model().kit().MD().method();
    MTS  * md_method = dynamic_cast<MTS *>(method);
    if (md_method)
        md_method->set_Switch (v);
}

void Panel_performance::
cut_large_forces (int state)
{
    MD_subject::set_cut_large_forces (state);
}

}//MM
