#include "Panel_profiler.h"

#include "Model.h"
#include "Model_kit.h"
#include "MD_simulator.h"
#include "Model_as_md_subject.h"
#include "Profiler.h"
#include "User.h"

namespace MM
{

Panel_profiler::
Panel_profiler ()
:
    Panel ("Profiler", "right")
{
    setupUi (this);
    
    connect(&qtimer_,                   SIGNAL(timeout()), 
            this,                       SLOT(renew_values()));
            //this,                       SLOT(update_ready()));
    //qtimer_.start(500);

    profile().set_on (true);
    profile().finish.subscribe (*this, &Panel_profiler::renew_values);
    renew_values ();
}

Panel_profiler::
~Panel_profiler ()
{
    profile().finish.clear();
    profile().set_on (false);
}

void Panel_profiler::
renew_values ()
{
    static Timer timer;
    if (timer.elapsed() < 0.5)
        return;
    timer.restart();

    spinBox_N                       ->setValue (profile().interactions___add_force___start_count_);
    doubleSpinBox_start                   ->setValue (profile().interactions___add_force___start_);
    doubleSpinBox_others                  ->setValue (profile().interactions___add_force___others_);
    doubleSpinBox_make_list               ->setValue (profile().interactions___add_force___make_list_);
    doubleSpinBox_make_sublist            ->setValue (profile().interactions___add_force___make_sublist_);
    doubleSpinBox_calc_nonbonded_force    ->setValue (profile().interactions___add_force___calc_nonbonded_force_);
    doubleSpinBox_add_atom_force          ->setValue (profile().interactions___add_force___add_atom_force_);
    doubleSpinBox_add_bond_force          ->setValue (profile().interactions___add_force___add_bond_force_);
    doubleSpinBox_add_full_nonbonded_force->setValue (profile().interactions___add_force___add_full_nonbonded_force_);
    doubleSpinBox_add_long_force          ->setValue (profile().interactions___add_force___add_long_force_);
    doubleSpinBox_add_switching_force     ->setValue (profile().interactions___add_force___add_switching_force_);
    doubleSpinBox_add_water_force         ->setValue (profile().interactions___add_force___add_water_force_);
    doubleSpinBox_flush_force             ->setValue (profile().interactions___add_force___flush_force_);
    doubleSpinBox_kick                    ->setValue (profile().kick_);
    doubleSpinBox_drift                   ->setValue (profile().drift_);
    doubleSpinBox_lock                    ->setValue (profile().lock_);
    doubleSpinBox_update                  ->setValue (profile().update_);

    doubleSpinBox_Sum->setValue (
        profile().interactions___add_force___start_ +
        profile().interactions___add_force___make_list_ +
        profile().interactions___add_force___make_sublist_ +
        profile().interactions___add_force___calc_nonbonded_force_ +
        profile().interactions___add_force___add_atom_force_ +
        profile().interactions___add_force___add_bond_force_ +
        profile().interactions___add_force___add_full_nonbonded_force_ +
        profile().interactions___add_force___add_long_force_ +
        profile().interactions___add_force___add_switching_force_ +
        profile().interactions___add_force___add_water_force_ +
        profile().interactions___add_force___flush_force_ +
        profile().kick_ +
        profile().drift_ +
        profile().lock_ +
        profile().update_ +
        profile().interactions___add_force___others_
        );

    MD_subject * subject = &model().kit().MD().subject ();
    Model_as_md_subject * md_subject = 
        dynamic_cast <Model_as_md_subject *>(subject);

    if (md_subject)
    {
        spinBox_list3->setValue (md_subject->list_3_size ());
        spinBox_list2->setValue (md_subject->list_2_size ());
        spinBox_list1->setValue (md_subject->list_1_size ());
    }

    update();
    to_user().clock ();
}

}//MM
