#ifndef PANEL_SEQUENCE_EDITOR_H
#define PANEL_SEQUENCE_EDITOR_H

#ifndef MODEL_KIT_H
#include "Model_kit.h"
#endif

#ifndef PANEL_H
#include "Panel.h"
#endif

#ifndef DYNAMIC_SINGLETON_H
#include "Dynamic_singleton.h"
#endif

#ifndef UI_PANEL_SEQUENCE_EDITOR_H
#include "ui_Panel_sequence_editor.h"
#endif

#ifndef MOLMECCANO_FILE_H
#include "MolMeccano_file.h"
#endif

#ifndef MODEL_IMPL_H
#include "Model_impl.h"
#endif

#include <QDir>

namespace MM
{

class Panel_sequence_editor
:
    public Panel,
    public Ui_Panel_sequence_editor,
    public Dynamic_singleton <Panel_sequence_editor>
{
    Q_OBJECT

    QDir            current_dir_;
//    int             current_conformation_n_;
    Model_impl      conformational_model_;

public:    
    MolMeccano_file conformational_file_;

    Panel_sequence_editor ();

public slots:
    void            change_repository         (QListWidgetItem *);
    void            renew_chain_type          ();
    void            renew_residues            ();
    void            renew_conformational_type ();
    void            renew_conformation_N      ();
    void            renew_conformation        ();
    void            add_residue               (QAction * action);

    QDir            repository ();

protected:
    void            no_conformation ();
};

}//MM

#endif //PANEL_SEQUENCE_EDITOR_H
