#include "Qt_add.h"

#include "User.h"

#include "Main_window.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "New_model.h"
#include "Create.h"

#include <QFileDialog>

namespace MM
{

void Qt_add::
execute()
{
    QFileDialog     dialog (Main_window::singleton(), "Choose a file to add", path ());
    dialog.setMinimumHeight (580);
    dialog.setMinimumWidth  (950);
    dialog.setAcceptMode    (QFileDialog::AcceptOpen);
    dialog.setViewMode      (QFileDialog::List);
    dialog.setFileMode      (QFileDialog::ExistingFile);

    QStringList filters = list_filters (for_open);
    dialog.setFilters(filters);

    if (dialog.exec())
    {
        QStringList file_names      = dialog.selectedFiles  ();
        selected_filter_            = dialog.selectedFilter ();
        QString     file_type_name  = 
            selected_filter_. section('(', 0, 0). trimmed ();

        Text file_type;

        if (file_type_name == "Any files"    || 
            file_type_name == "Any chemical" ||
            file_type_name.isEmpty()//fix
           ) 
            file_type = "auto detect";
        else
            file_type = file_type_name;

            QStringList::Iterator it = file_names.begin();

            while (it != file_names.end()) 
            {
                QString file_name = *it;
                path () = file_name;

                Model & model =  Project::singleton().current_model ();
                model.kit().add_builder().
                    load (Text(file_name).c_str(), file_type.c_str());

                ++it;
            }
    }
}

}//MM
