#include "Qt_choose_file.h"

#include "User.h"

#include "Main_window.h"
#include "Model_RM_window.h"
#include "Project.h"
#include "Model.h"
#include "Model_kit.h"
#include "New_model.h"
#include "Create.h"

#include <QFileDialog>

namespace MM
{

QStringList Qt_choose_file::
list_filters (Intention intention) const
{
    QStringList result;

    if (!selected_filter_.isEmpty())
        result << selected_filter_;

    QString     all_chemical_filter ("Any chemical (*.mlm "); 
    QStringList filters;

    int k = Model_file::prototype_count();
    bool first_all_chemical_record = true;

    for (int i=0;  i<k;  ++i)
    {
        Model_file const & file_type = Model_file::prototype (i);
        QString current_filter = file_type.type_name();

        if (current_filter == "MolMeccano")
            continue;
        
        bool support;
        if (intention == for_open)
            support = file_type.support_input();
        else if (intention == for_save)
            support = file_type.support_output();
        else FLAW ("@ Qt_choose_file::list_filters");

        if (support)
        {

            int type_name_length = file_type.type_name().length();
            for (int space=type_name_length;  space<12;  ++space)
                current_filter += "  ";

            current_filter += "  (";

            if (first_all_chemical_record)
                first_all_chemical_record = false;
            else
                all_chemical_filter += " ";

            int  n = file_type.extension_count();
            bool first_extension_record = true;

            for (int j=0;  j<n;  ++j)
            {
                if (first_extension_record)
                    first_extension_record = false;
                else
                    {
                        current_filter      += " ";
                        all_chemical_filter += " ";
                    }

                current_filter      += "*.";
                all_chemical_filter += "*.";
                current_filter      += file_type.extension(j);
                all_chemical_filter += file_type.extension(j);
            }
            current_filter += ")";

            filters << current_filter;
        }
    }
    all_chemical_filter += ")";

    if (intention == for_open)
        result << all_chemical_filter << "Any files           (*.*)";

    result << "MolMeccano      (*.mlm)" << filters;
    return result;
}

Model & Qt_choose_file::
current_model ()
{
    QWidget * widget = Main_window::singleton ()->current_model_window();
    CHECK ("Current model window exist.", widget != 0);

    Model_RM_window * window = dynamic_cast <Model_RM_window *>(widget);

    return window->model();
}

}//MM
